<?php
/***************************************************************************
 *  					Theme Functions
 * 	----------------------------------------------------------------------
 * 						DO NOT EDIT THIS FILE
 *	----------------------------------------------------------------------
 *
 *  					Copyright (C) Themify
 * 						https://themify.me
 *
 *  To add custom PHP functions to the theme, create a child theme (https://themify.me/docs/child-theme) and add it to the child theme functions.php file.
 *  They will be added to the theme automatically.
 *
 ***************************************************************************/

const THEMIFY_PORTFOLIO_POSTS_COMPAT_MODE = true;

Themify_Enqueue_Assets::$mediaMaxWidth=false;
/////// Actions ////////
// Init post, page and additional post types if they exist
add_action( 'after_setup_theme', 'themify_theme_init_types' );


// Register sidebars
add_filter('themify_register_sidebars','themify_theme_register_sidebars');

// Exclude CPT for sidebar
add_filter( 'themify_exclude_CPT_for_sidebar', 'themify_CPT_exclude_sidebar' );

// Set class on body tag according to layout width
add_filter( 'body_class', 'themify_theme_body_class', 99 );

// Widget Search ajax feature
if( ! function_exists('themify_theme_widget_search_ajax_option') ) {
    function themify_theme_widget_search_ajax_option($widget, $return, $instance) {
        if($widget->id_base!=='search'){
            return;
        }
        $key='tf_search_ajax';
        $v = isset( $instance[$key] ) ? $instance[$key] : '';
        ob_start();
        ?>
        <p>
            <label for="<?php echo esc_attr( $widget->get_field_id( $key ) ) ?>">
                <input class="widefat" <?php echo checked( $v ,1, false ) ?> value="1" id="<?php echo esc_attr( $widget->get_field_id( $key ) ) ?>" name="<?php echo esc_attr( $widget->get_field_name( $key ) ) ?>" type="checkbox" />
                <?php _e( 'Enable Ajax search', 'themify' ) ?>
            </label>
        </p>
        <?php
        ob_get_flush();
    }
    add_action( 'in_widget_form', 'themify_theme_widget_search_ajax_option', 10, 3 );
}

if ( ! function_exists( 'themify_theme_widget_search_ajax_update' ) ) {
    add_action( 'widget_update_callback', 'themify_theme_widget_search_ajax_update', 10, 2 );
    function themify_theme_widget_search_ajax_update( $instance, $new_instance ) {
        $key='tf_search_ajax';
        $instance[$key] = ! empty( $new_instance[$key] ) ? $new_instance[$key] : '';
        return $instance;
    }
}
function themify_theme_search_widget( $instance, $widget_obj, $args){
    if($widget_obj instanceof WP_Widget_Search ){
        global $tf_isWidget;
        $tf_isWidget=!empty($instance['tf_search_ajax']);
    }
    return $instance;
}
add_filter('widget_display_callback','themify_theme_search_widget',100,3);
/**
 * Enqueue Stylesheets and Scripts in header
 * will be called class-themify-enqueue.php 
 * @since 1.0.0
 */
function themify_theme_enqueue_header() {
	
	// Get theme version for Themify theme scripts and styles
	$theme_version = Themify_Enqueue_Assets::$themeVersion;
	$header=themify_theme_get_header_design();
	$sticky_header=themify_theme_sticky_logo();
	Themify_Enqueue_Assets::preFetchSideMenuJs();
	Themify_Mega_Menu_Walker::$disableAssetsLoading=$header==='header-left-pane' || $header==='header-right-pane' || $header==='header-minbar-left'  || $header==='header-minbar-right' || $header==='header-overlay'  || $header==='header-slide-left' || $header==='header-slide-right';

	// Prepare JS variables
	$themify_script_vars = array(
	    'headerType'=>  $header
	);
	if($sticky_header!==false){
	    $themify_script_vars['sticky_header']=$sticky_header;
	}
	unset($sticky_header);
	if(!themify_check( 'setting-infinite-url',true  )){
	    $themify_script_vars['infiniteURL']=1;
	}
	if(!themify_check( 'setting-autoinfinite',true  )){
	    $themify_script_vars['autoInfinite']='auto';
	}

 
	if( themify_is_woocommerce_active() ) {
		$gallerType = themify_get_gallery_type();
		// Load WooCommerce PrettyPhoto resources to fix image gallery in product lightbox
		
		if( $gallerType === 'default' ) {
			if(!is_product()){
				global $wp_scripts;
				$js=array('flexslider','photoswipe-ui-default','zoom');
				$themify_script_vars['wc_gal']=array();
				foreach ($js as $v) {
					if (isset($wp_scripts->registered[$v])) {
						if(!empty($wp_scripts->registered[$v]->deps)){
							foreach ($wp_scripts->registered[$v]->deps as $v2) {
								if ($v2!=='jquery' && $v2!=='jquery-core' && isset($wp_scripts->registered[$v2])) {
									$themify_script_vars['wc_js'][$v2]=array('s'=>$wp_scripts->registered[$v2]->src,'v'=>$wp_scripts->registered[$v2]->ver);
								}
							}
						}
						$themify_script_vars['wc_gal'][$v]=array('s'=>$wp_scripts->registered[$v]->src,'v'=>$wp_scripts->registered[$v]->ver);
					}
				}
			}
		}
		else{
			wp_dequeue_script( 'zoom');
		}

		
		if(!themify_check('setting-spark_animation',true )){			
		    $themify_script_vars['sparkling_color']=themify_get( 'setting-spark_color','#dcaa2e',true );
		}
		Themify_Enqueue_Assets::addPreLoadJs(THEME_URI . '/js/modules/themify-shop.js',$theme_version);
		// Inject variable values in themify-shop.js
		// Can be filtered hooking to themify_shop_js_vars
		$themify_script_vars+= apply_filters(
			'themify_shop_js_vars',
			array(
				'redirect'=> get_option( 'woocommerce_cart_redirect_after_add' ) === 'yes' ? wc_get_cart_url() : false,
				'lng'=>array(
				    'add_to'=>__('Added to Cart', 'themify'),
				    'keep_shop'=>__('Keep Shopping', 'themify'),
				    'checkout'=>__('Checkout', 'themify'),
				),
				'checkout_url'=>wc_get_checkout_url(),
				'wc_css_url'=>THEME_URI . '/styles/wc/modules/',
				'placeholder' => wc_placeholder_img_src()
			)
		);
		if($themify_script_vars['redirect']===false){
		    unset($themify_script_vars['redirect']);
		}
		if(!themify_check( 'setting-optimize-wc', true )){
            add_filter('woocommerce_get_script_data','themify_theme_wc_variable_product_data',10,2);
        }
		$cart_delay=intval(themify_get( 'setting-cart_show_seconds','',true ));
		if($cart_delay>0){
			$themify_script_vars['ajaxCartSeconds']=$cart_delay;
		}
		if(is_product() && !themify_check( 'setting-single_ajax_cart',true )){
            $themify_script_vars['ajaxSingleCart']=true;
        }

		/**
		 * WooCommerce Product Search patch
		 * @link https://woocommerce.com/products/woocommerce-product-search/
		 */
		if ( ! is_admin() && function_exists( 'woocommerce_product_search_boot' ) ) {
			themify_enque_script( 'themify-woocommerce_product_search', THEME_URI . '/woocommerce/js/woocommerce-product-search.min.js', Themify_Enqueue_Assets::$themeVersion, array( 'jquery' ) );
		}
	}
	$dark_mode=themify_theme_dark_mode();
	if('schedule'===$dark_mode){
		$start = themify_get( 'setting-dark_mode_start',null,true );
		$end = themify_get( 'setting-dark_mode_end',null,true );
		if(!empty($start) && !empty($end)){
			$themify_script_vars['darkmode']=array(
				'start'=>$start,
				'end'=>$end
			);
		}
	} elseif ( 'user' === $dark_mode ) {
		$themify_script_vars['darkmode'] = 1;
	}

	if ( themify_check( 'menu_tooltips' ) ) {
		Themify_Enqueue_Assets::addLocalization( 'menu_tooltips', '#main-nav', 'arr' );
	}

	// Pass variable values to JavaScript
	wp_localize_script( 'themify-main-script', 'themifyScript', apply_filters( 'themify_script_vars', $themify_script_vars ) );
}

/**
 * Enqueue Stylesheets and Scripts in footer
 * will be called class-themify-enqueue.php 
 */
function themify_theme_enqueue_footer(){
    $theme_version = Themify_Enqueue_Assets::$themeVersion;
    add_action('themify_after_skin_css','themify_theme_after_skin');
    // Themify base styling
	if ( themify_is_woocommerce_active() ) {
		if ( is_product() ) {
			$layout = themify_get_both( 'image_layout','setting-product_image_layout' ,'img-left');
			if ( $layout !== 'image-left' && $layout !== 'img-left' ) {
				Themify_Enqueue_Assets::loadThemeWCStyleModule( 'single/' . $layout );
			}
		} 
		elseif ( Themify_Wishlist::$is_wishlist_page === true ) {
			Themify_Enqueue_Assets::loadThemeWCStyleModule( 'wishlist' );
		}
		if('dropdown'===themify_get_cart_style()){
			Themify_Enqueue_Assets::loadThemeWCStyleModule( 'basket' );
		}
	}
    $header = themify_theme_get_header_design();
    if( $header !== '' && $header !== 'default' && $header !== 'header-none'  && $header !== 'header-logo-center'  ) {
		if(Themify_Mega_Menu_Walker::$disableAssetsLoading===true){
			themify_enque_style( $header.'-menu', THEME_URI . '/styles/headers/mobile-menu.css', null,$theme_version );
		}
		themify_enque_style( $header, THEME_URI . '/styles/headers/' . $header . '.css', null,$theme_version );
		if($header!=='header-bottom' && $header!=='header-logo-left'  && $header!=='header-boxed-layout'){
			Themify_Enqueue_Assets::addMobileMenuCss('header-'.$header.'-menu',THEME_URI . '/styles/headers/media/'.$header.'.css');
		}
    }
    // Themify Mobile Menu
    $menu_style = themify_theme_get_menu_style();
    if (  $menu_style!==false ) {
	if(in_array($menu_style, array('boxed','fadein-down','flip-down','flipin-left','flipin-right','slide-left-content','slidein-left','slidein-right','split','swing-left-to-right','swing-right-to-left','swing-top-to-bottom','swipe-left','swipe-right','slide-down'),true)){
	    Themify_Enqueue_Assets::addMobileMenuCss('menu-animations',THEME_URI . '/styles/menus/animations.css');
	}
	Themify_Enqueue_Assets::addMobileMenuCss( 'mobile-menu-' . $menu_style ,  THEME_URI . '/styles/menus/'. $menu_style . '.css');
    }
}
add_action( 'comment_form', 'themify_comment_form_css',10,1 );
function themify_comment_form_css($post_id){
	remove_action( 'comment_form', 'themify_comment_form_css',10,1 );
	Themify_Enqueue_Assets::loadThemeStyleModule('comments');
}

add_action( 'pre_get_search_form', 'themify_theme_search_form_css' );
function themify_theme_search_form_css(){
    remove_action( 'pre_get_search_form', 'themify_theme_search_form_css' );
    Themify_Enqueue_Assets::loadThemeStyleModule('search-form');
}
/**
 * Load Google fonts used by the theme
 *
 * @return array
 */
function themify_theme_google_fonts(array $fonts =array()):array {
	/* translators: If there are characters in your language that are not supported by Libre Franklin, translate this to 'off'. Do not translate into your own language. */
	if ( 'off' !== _x( 'on', 'Libre Franklin font: on or off', 'themify' ) ) {
	    $fonts['libre-franklin'] = 'Libre+Franklin:400,300,500,600,700';
	}
	return $fonts;
}

function themify_theme_avatar_size():int{
    return 85;
}

add_filter('themify_comment_avatar_size','themify_theme_avatar_size');
add_filter( 'themify_google_fonts', 'themify_theme_google_fonts' );
function themify_theme_wc_variable_product_data($params,$handle){
    if($handle==='wc-add-to-cart-variation'){
		wp_dequeue_script( 'wc-add-to-cart-variation');
		remove_filter('woocommerce_get_script_data','themify_theme_wc_variable_product_data',10,2);
		wp_localize_script( 'themify-main-script', 'wc_add_to_cart_variation_params', $params );
    }
    return $params;
}
/**
 * Logic for fixed header. Checks, if it applies, custom fields first and then theme settings.
 *
 * @since 1.0.0
 */
function themify_theme_fixed_header():string {
	static $is = null;
	if ( $is === null ){
		$is = '';
		if ( themify_theme_revealing_header_enabled() ) {
			$is = 'fixed-header-enabled';
		} else if ( ! in_array( themify_theme_get_header_design(), array( 'none', 'header-bottom', 'header-left-pane', 'header-right-pane', 'header-minbar-left', 'header-minbar-right' ),true ) && ! themify_theme_revealing_header_enabled() ) {
			$is = themify_get_both( 'fixed_header','setting-fixed_header_disabled' );
			/* "on": disabled in theme settings, "no": disabled in Page Appearance */
			$is = $is === 'no' || $is === 'on' ? '' : 'fixed-header-enabled';
		}
	}

	return $is;
}

function themify_theme_revealing_header_enabled() {
	static $is = null;
	if ( $is === null ) {
		$is = false;
		if ( ! in_array( themify_theme_get_header_design(), [ 'header-minbar', 'header-boxed-content', 'header-slide-left', 'header-slide-right' ], true ) ) {
			$is = is_singular() ? themify_get( 'revealing_header' ) : null;
			$is = $is === null ? themify_get( 'setting-revealing_header', '', true ) === 'on' : $is === 'yes';
		}
	}

	return $is;
}

function themify_theme_revealing_footer_enabled() {
	static $is = null;
	if ( $is === null ) {
		$is = false;
		if ( themify_theme_show_area( 'footer' ) ) {
			$is = is_singular() ? themify_get( 'revealing_footer' ) : null;
			$is = $is === null ? themify_get( 'setting-revealing_footer', '', true ) === 'on' : $is === 'yes';
		}
	}

	return $is;
}

if ( ! function_exists( 'themify_theme_body_class' ) ) {
	/**
	 * Adds body classes for special theme features.
	 */
	function themify_theme_body_class(array $classes=array() ):array {
		
		$header = themify_theme_get_header_design();
		if($header!=='default'){
			$classes[] = $header;
		}
		
		if(themify_is_woocommerce_active()){
		    $classes[] = 'cart-style-'.themify_get_cart_style();
		    if(!empty(WC()->cart) && empty(WC()->cart->get_cart())){
			$classes[] = 'wc-cart-empty';
		    }
		    if(is_product()){
			$classes[] = 'product-'.themify_get_both( 'image_layout','setting-product_image_layout' ,'img-left');
		    }
		}
		if ( ! in_array( $header, array( 'header-left-pane', 'header-right-pane', 'header-minbar', 'header-none' ),true ) ) {
			// Add transparent-header class to body if user selected it in custom panel
			if ( ( is_single() || is_page() || themify_is_shop() ) && 'transparent' === themify_get( 'header_wrap' ) ) {
				Themify_Enqueue_Assets::loadThemeStyleModule('transparent-header');
				$classes[] = 'transparent-header';
			}
			if( themify_theme_revealing_header_enabled() ) {
				$classes[] = 'revealing-header';
			}
			$fixedHeader=themify_theme_fixed_header();
			if($fixedHeader!==''){
				$classes[]=$fixedHeader;
			}
		}
		

		// Footer Design
		$footer = themify_area_design( 'footer', array(
			'default' => 'footer-block',
			'values'  => wp_list_pluck( themify_theme_footer_design_options(), 'value' ),
		) );
		if('none' !== $footer){
		    if($footer==='default'){
				$footer='footer-block';
		    }
		    $classes[]=$footer;
			if($footer!=='footer-left-column'){
				Themify_Enqueue_Assets::loadThemeStyleModule('footers/'. str_replace('footer-', '', $footer));
			}
		}
		else{
		    $classes[]='footer-none';
		}

		// Exclusion classes
		if ( ! themify_theme_show_area( 'site_logo' ) ) {
			$classes[] = 'logo-off';
		}
		if ( ! themify_theme_show_area( 'site_tagline' ) ) {
			$classes[] = 'tagline-off';
		}
		if ( ! themify_theme_show_area( 'search_form' ) ) {
			$classes[] = 'search-off';
		}
		if ( ! themify_theme_show_area( 'menu_navigation' ) ) {
			$classes[] = 'menu-navigation-off';
		}
		else{
		    $menu_style = themify_theme_get_menu_style();
		    if ( $menu_style!==false ) {
			$classes[] = 'menu-' . $menu_style;
		    }
		}
		if ( ! themify_theme_show_area( 'wishlist' ) ) {
			$classes[] = 'wishlist-icon-off';
		}
		if ( ! themify_theme_show_area( 'cart' ) ) {
			$classes[] = 'cart-icon-off';
		}
		if ( ! themify_theme_show_area( 'top_bar_widgets' ) ) {
			$classes[] = 'top-bar-widgets-off';
		}
		if ( ! themify_theme_show_area( 'footer' ) ) {
			$classes[] = 'footer-off';
		}
		elseif('none' !== $footer){
		    if( themify_theme_revealing_footer_enabled() ) {
				Themify_Enqueue_Assets::loadThemeStyleModule('revealing-footer');
				$classes[] = 'revealing-footer';
		    }
		}
		if ( ! themify_theme_show_area( 'footer_widgets' ) ) {
			$classes[] = 'footer-widgets-off';
		}
		if ( ! themify_theme_show_area( 'footer_menu_navigation' ) ) {
			$classes[] = 'footer-menu-navigation-off';
		}
				
		// Image Filters
		$filter =$filter_hover = $apply_to = '';
		global $themify;
		if ( is_singular() || themify_is_shop()) {

			if ( $do_filter = themify_get( 'imagefilter_options' ) ) {
				if ( 'initial' !== $do_filter ) {
					$filter = 'filter-' . $do_filter;
				}
			}

			if ( $do_hover_filter = themify_get( 'imagefilter_options_hover' ) ) {
				if ( 'initial' !== $do_hover_filter ) {
					$filter_hover = 'filter-hover-' . $do_hover_filter;
				}
			}

			if ( $apply_here = themify_get('imagefilter_applyto') ) {
				if ( 'initial' !== $apply_here ) {
					$apply_to = 'filter-' . $apply_here;
				}
			}
		}
		if ( '' === $filter && ($do_filter = themify_get( 'setting-imagefilter_options',false,true ) )) {
		    $filter = 'filter-' . $do_filter;
		}

		if ( '' === $filter_hover ) {
			if ( $do_hover_filter = themify_get( 'setting-imagefilter_options_hover',false,true ) ) {
				$filter_hover = 'filter-hover-' . $do_hover_filter;
			} else {
				$filter_hover = 'filter-hover-none';
			}
		}

		if ( '' === $apply_to && ('' !== $filter || '' !== $filter_hover)) {
		    $apply_to = 'allimages' === themify_get('setting-imagefilter_applyto',false,true)?'filter-all':'filter-featured-only';
		}
		$classes[] = $themify->layout;
		if($filter!=='' || $filter_hover!=='' || $apply_to!==''){
			if($filter!==''){
				$classes[] = $filter;
			}
			if($filter_hover!==''){
				$classes[] = $filter_hover;
			}
			$classes[] = $apply_to;
		}
		if(($post_layout = array_search('auto_tiles',$classes))!==false){
			Themify_Enqueue_Assets::loadAutoTilesCss();
			unset($classes[$post_layout]);
		}

		if ($themify->layout !== 'sidebar-none' ) {
			Themify_Enqueue_Assets::loadThemeStyleModule('sidebars/left');
			if( $themify->sticky_sidebar){
				Themify_Enqueue_Assets::loadThemeStyleModule('sidebars/sticky');
				$classes[] = 'sticky_sidebar_enabled';
			}
		}
		else{
			Themify_Enqueue_Assets::loadThemeStyleModule('sidebars/none');
		}

        // Reset corners
        if(themify_get( 'setting-rounded_corners_images', null,true) === 'on' ) {
            $classes[] = 'no-rounded-image';
            Themify_Enqueue_Assets::loadThemeStyleModule('rounded-images');
        }
        if(themify_get( 'setting-rounded_corners_inputs', null,true) === 'on' ) {
            $classes[] = 'no-rounded-input';
            Themify_Enqueue_Assets::loadThemeStyleModule('rounded-inputs');
        }
        if('always'===themify_theme_dark_mode()){
            $classes[] ='tf_darkmode';
        }
		return $classes;
	}
}

/**
 * Checks if .animated-bg class must be output and sets the first animation color as initial background
 * Displays the data-bg and class attributes, including the background image and fullcover class
 *
 * @since 1.0.0
 *
 * @param string $area
 * @param string $classes Additional CSS classes to output for this element
 */

function themify_theme_header_background( $area = 'header', $classes = '' ) {
	$class = $repeat =$data_bg = '';
	$area_wrap = themify_get( $area . '_wrap' );
	if ( 'header' === $area && ($area_wrap==='video' || $area_wrap==='slider')) {
		$back_key = 'styling-background-header_wrap_background-background_image-value-value';
		$mode_key = 'styling-background-header_wrap_background-background_mode-value-value';
		$header_customizer = json_decode( get_theme_mod( 'headerwrap_background' ) );
		$image = null;
		if ( !empty( $header_customizer->src )) {
			$image = $header_customizer->src;
			$repeat = isset( $header_customizer->style ) ? $header_customizer->style : 'fullcover';
		} elseif ( themify_check( $back_key ) ) {
			$image = themify_get( $back_key );
			$repeat = themify_get( $mode_key,'fullcover');
		}

		if ( is_singular() ) {
			global $themify;

			$post_id = is_page()?$themify->page_id:get_the_ID();
			
			$image_meta = get_post_meta($post_id, 'background_image', true);
			if ( $image_meta ) {
				$image = $image_meta;
				$repeat_meta = get_post_meta($post_id, 'background_repeat', true);
				if ( $repeat_meta ) {
					$repeat = $repeat_meta;
				}
			}
			
			if ( $area_wrap === 'slider' ) {
                            $background_color = get_post_meta( $post_id, 'background_color', true );
                            if($background_color != ''){
                                $data_bg .= "data-bgcolor='$background_color'";
                            }
			}
                        elseif ( 'video' === $area_wrap ) {
                            $video = get_post_meta( $post_id, 'video_file', true );
                            if($video!=''){
				Themify_Enqueue_Assets::loadThemeStyleModule('header-video');
                                $data_bg .= " data-fullwidthvideo='$video'";
                            }
			}
			$background_gallery = get_post_meta( $post_id, 'background_gallery', true );
			$nobg_key = 'styling-background-header_wrap_background-background_image-value-none';
			$nobg = themify_get( $nobg_key ) || ( isset( $header_customizer->noimage ) && 'noimage' === $header_customizer->noimage );
			if ( $gallery = ( ( $area_wrap === 'slider' ) || ( $area_wrap === '' && $background_gallery != '' ) ) ) {
				$repeat = 'fullcover header-gallery';
			} elseif ( $nobg ) {
				// Checks $image_meta because $image might have been set in customizer and we don't need to check that.
				if ( $image_meta && is_singular()) {
					$data_bg .= " data-bg='$image'";
				}
			} elseif ( $image ) {
				$data_bg .= " data-bg='$image'";
			}
		}
	}

	if ( $repeat || $classes!=='' ) {
		$class = "class='$repeat $classes'";
	}

	echo "$data_bg $class";
}
if ( ! function_exists( 'themify_theme_show_area' ) ) {
	/**
	 * Checks whether to show a certain layout area or not.
	 *
	 * @param string $area
	 *
	 * @return bool
	 */
	function themify_theme_show_area( $area = '' ) {
		static $arr=array(); 
		if(!isset($arr[$area])){
			$show = true;
			switch ( $area ) {
				case 'header':
					$show = 'none' === themify_area_design( $area, array( 'values'  => wp_list_pluck( themify_theme_header_design_options(), 'value' ) ) ) ? false : true;
					break;
				case 'footer':
					$show = 'none' === themify_area_design( $area, array( 'values'  => wp_list_pluck( themify_theme_footer_design_options(), 'value' ) ) ) ? false : true;
					break;
				default:
				if ( is_singular() && ! is_attachment() ) {
					$exclude = themify_get( 'exclude_' . $area );
					if ( 'yes' === $exclude ) {
						$show = false;
					} elseif ( 'no' === $exclude ) {
						$show = true;
					} else {
						$show = !themify_check( 'setting-exclude_' . $area,true );
					}
				} elseif ( themify_check( 'setting-exclude_' . $area,true ) ) {
					$show = false;
				}
				break;
			}
			$arr[$area]=apply_filters( "themify_theme_show_{$area}", $show );
		}
		return $arr[$area];
	}
}
// Add Categories link to mega menu
function themify_mega_menu_add_category_link($out,$term_id,$taxonomy):string{
	return $out.'<a class="themify_mega_menu_category_link" href="'.get_term_link((int)$term_id,$taxonomy).'">'.__('View all').'</a>';
}
add_filter('themify_mega_posts_output','themify_mega_menu_add_category_link',10,3);


if ( ! function_exists( 'themify_theme_do_not_exclude_all' ) ) {
	/**
	 * Checks if all the elements in a certain area have been excluded.
	 *
	 * @since 1.0.0
	 *
	 * @param string $area
	 *
	 * @return bool
	 */
	function themify_theme_do_not_exclude_all( $area = 'header' ):bool {
		if ( 'mobile-menu' === $area ) {
			return themify_theme_show_area( 'search_icon' ) || themify_theme_show_area( 'top_bar_widgets' ) || themify_theme_show_area( 'menu_navigation' );
		} elseif ( 'header' === $area ) {
			return themify_theme_show_area( 'site_logo' ) || themify_theme_show_area( 'site_tagline' ) || themify_theme_show_area( 'search_icon' ) || themify_theme_show_area( 'top_bar_widgets' ) || themify_theme_show_area( 'menu_navigation' );
		} elseif ( 'footer' === $area ) {
			return themify_theme_show_area( 'footer_site_logo' ) || themify_theme_show_area( 'footer_menu_navigation' ) || themify_theme_show_area( 'footer_texts' ) || themify_theme_show_area( 'footer_widgets' ) || themify_theme_show_area( 'footer_back' );
		}
		return false;
	}
}

/**
 * Register theme support.
 *
 * Initialize custom panel with its definitions.
 * Custom panel definitions are located in admin/post-type-TYPE.php
 *
 * @since 1.0.7
 */
function themify_theme_init_types() {
	// Load Themify Social Share
	add_theme_support( 'post-thumbnails' );

	// Load Themify Mega Menu
	add_theme_support( 'themify-mega-menu' );
	// Load Themify Toggle dropdown menu
	add_theme_support( 'themify-toggle-dropdown' );

	/* disable Builder lightbox's default template */
	add_theme_support( 'themify-builder-lightbox-template' );

	$supportedCss=array(
	    'auto_tiles',
	    'grid2-thumb',
	    'grid2',
	    'grid3',
	    'grid4',
	    'grid5',
	    'grid6',
	    'list-large-image',
	    'list-post',
	    'list-thumb-image',
	    'slider',
	    'widget_calendar',
	    'widget_feature-posts-list',
	    'widget_recent-comments',
	    'widget_recent-posts',
	    'widget_text',
	    'widget_themify-flickr',
	    'widget_themify-twitter',
	    'comments'
	);
	foreach ($supportedCss as $css){
	    Themify_Enqueue_Assets::add_theme_support_css($css);
	}
	if ( themify_is_woocommerce_active() ) {
	    // Load Themify Wishlist
	    require_once THEME_DIR.'/class-wishlist.php';
		
	    require_once THEME_DIR . '/woocommerce/themify-wc.php'; // WooCommerce overrides
	    // Load Sticky cart feature
	    add_theme_support( 'themify-sticky-buy' );
	    // Load Single Product Accordion tab
	    add_theme_support( 'themify-wc-accordion-tabs' );
	    //add wc css 
	    Themify_Enqueue_Assets::add_theme_support_css( 'wc' );
	    $supportedCss=array('wc_account','wc_cart','wc_checkout','wc_register_form','wc_single_product');
	    foreach ($supportedCss as $css){
		Themify_Enqueue_Assets::add_theme_support_css($css);
	    }
	}
	unset($supportedCss);
	require_once THEME_DIR.'/class-social-share.php';

	// Load required files for post, page and custom post types where it applies
	require_once( THEME_DIR.'/admin/post-type-portfolio.php' );
	register_nav_menus( array(
		'main-nav' => __( 'Main Navigation', 'themify' ),
		'icon-menu'=>__('Icon Navigation','themify'),
		'footer-nav' => __( 'Footer Navigation', 'themify' )
	));
	if(is_child_theme()){
	    include THEME_DIR.'/deprecated.php';
	}
}
/**
 * Register sidebars
 * @since 1.0.0
 */
function themify_theme_register_sidebars(array $sidebars=array()):array {
	foreach($sidebars as $k=>$s){
	    if($s['id']==='social-widget'){
		unset($sidebars[$k]);
		break;
	    }
	}
	$sidebars[]=array(
		'name' => __( 'Top Bar Left', 'themify' ),
		'id' => 'top-bar-left',
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget' => '</div>',
		'before_title' => '<h4 class="widgettitle">',
		'after_title' => '</h4>'
	);

	$sidebars[]=array(
		'name' => __( 'Top Bar Right', 'themify' ),
		'id' => 'top-bar-right',
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget' => '</div>',
		'before_title' => '<h4 class="widgettitle">',
		'after_title' => '</h4>'
	);

	$sidebars[]=array(
		'name' => __('Below Footer Logo Widget', 'themify'),
		'id' => 'below-logo-widget',
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget' => '</div>',
		'before_title' => '<strong class="widgettitle">',
		'after_title' => '</strong>'
	);
	if(themify_is_woocommerce_active() && !themify_check('setting-disable_shop_sidebar',true)){
		$sidebars[] = array(
			'name' => __( 'Shop Sidebar', 'themify' ),
			'id' => 'sidebar-shop',
			'description'=>__('This sidebar will show in WooCommerce pages only.','themify'),
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="widgettitle">',
			'after_title' => '</h4>'
		);
	}
	return $sidebars;
}

function themify_theme_get_sidebar_type():string{
	$is_wc_active = themify_is_woocommerce_active();
	$sidebar = 'sidebar-main';
	if ( is_page() ) {
		$page_sidebar = themify_get( 'sidebar_type' );
		if ($page_sidebar) {
            $page_sidebar=false===$is_wc_active && $page_sidebar==='shop'?'main':$page_sidebar;
			$sidebar = 'sidebar-' . $page_sidebar;
		}
	} elseif ( $is_wc_active===true && ! themify_check( 'setting-disable_shop_sidebar', true ) && ( is_woocommerce() || is_cart() || is_checkout() || is_wc_endpoint_url() || is_account_page() ) ) {
		$sidebar = 'sidebar-shop';
	}

	return $sidebar;
}

/**
 * Returns options for header design. Used in custom panel and theme settings.
 *
 * @since 1.0.0
 *
 * @return array List of header design options.
 */
function themify_theme_header_design_options():array {
	return apply_filters( 'themify_theme_header_design_options', array(
		
		array(
			'value' => 'default',
			'img'   => 'themify/img/default.svg',
			'title' => __( 'Default', 'themify' ),
			'selected' => true,
		),
		array(
			'value' => 'header-logo-center',
			'img'   => 'images/layout-icons/header-logo-center.png',
			'title' => __( 'Header Logo Center', 'themify' ),
			'selected' => true,
		),
		array(
			'value' => 'header-logo-left', 
			'img'   => 'images/layout-icons/header-logo-left.png',
			'title' => __( 'Header Logo Left', 'themify' ),
		),
		array(
			'value' => 'header-block',
			'img'   => 'images/layout-icons/header-block.png',
			'title' => __( 'Header Block', 'themify' ),
		),
		array(
			'value' => 'header-boxed-layout',
			'img'   => 'images/layout-icons/header-boxed-layout.png',
			'title' => __( 'Header Boxed Layout', 'themify' ),
		),
		array(
			'value' => 'header-left-pane', 
			'img'   => 'images/layout-icons/header-leftpanel.png',
			'title' => __( 'Header Left Pane', 'themify' ),
		),
		array(
			'value' => 'header-right-pane', 
			'img'   => 'images/layout-icons/header-rightpanel.png',
			'title' => __( 'Header Right Pane ', 'themify' ),
		),
		array(
			'value' => 'header-minbar-left', 
			'img'   => 'images/layout-icons/header-minbar-left.png',
			'title' => __( 'Header Min Bar Left', 'themify' ),
		),
		array(
			'value' => 'header-minbar-right', 
			'img'   => 'images/layout-icons/header-minbar-right.png',
			'title' => __( 'Header Min Bar Right', 'themify' ),
		),
		array(
			'value' => 'header-overlay', 
			'img'   => 'images/layout-icons/header-overlay.png',
			'title' => __( 'Header Overlay ', 'themify' ),
		),
		array(
			'value' => 'header-slide-left', 
			'img'   => 'images/layout-icons/header-slide-left.png',
			'title' => __( 'Header Slide Left', 'themify' ),
		),
		array(
			'value' => 'header-slide-right', 
			'img'   => 'images/layout-icons/header-slide-right.png',
			'title' => __( 'Header Slide Right', 'themify' ),
		),
		array(
			'value' => 'header-stripe',
			'img'   => 'images/layout-icons/header-stripe.png',
			'title' => __( 'Header Stripe', 'themify' ),
		),
		array(
			'value' => 'header-boxed-content', 
			'img'   => 'images/layout-icons/header-boxed-content.png',
			'title' => __( 'Header Boxed Content', 'themify' ),
		),
		array(
			'value' => 'header-bottom',
			'img'   => 'images/layout-icons/header-bottom.png',
			'title' => __( 'Header Bottom', 'themify' ),
		),
		array(
			'value' => 'none', 
			'img'   => 'images/layout-icons/none.png',
			'title' => __( 'No Header ', 'themify' ),
		)
	));
}

/**
 * Returns options for footer design. Used in custom panel and theme settings.
 *
 * @since 1.0.0
 *
 * @return array List of footer design options.
 */
function themify_theme_footer_design_options():array {
	return apply_filters( 'themify_theme_footer_design_options', array(
		array(
			'value' => 'default',
			'img'   => 'themify/img/default.svg',
			'title' => __( 'Theme Default', 'themify' ),
			'selected' => true,
		),
		array(
			'value' => 'footer-block',
			'img'   => 'images/layout-icons/footer-block.png',
			'title' => __( 'Footer Block', 'themify' ),
		),
		array(
			'value' => 'footer-left-column',
			'img'   => 'images/layout-icons/footer-left-column.png',
			'title' => __( 'Footer Left Column', 'themify' ),
		),
		array(
			'value' => 'footer-right-column',
			'img'   => 'images/layout-icons/footer-right-column.png',
			'title' => __( 'Footer Right Column', 'themify' ),
		),
		array(
			'value' => 'footer-horizontal-left',
			'img'   => 'images/layout-icons/footer-horizontal-left.png',
			'title' => __( 'Footer Horizontal Left', 'themify' ),
		),
		array(
			'value' => 'footer-horizontal-right',
			'img'   => 'images/layout-icons/footer-horizontal-right.png',
			'title' => __( 'Footer Horizontal Right', 'themify' ),
		),
		array(
			'value' => 'none',
			'img'   => 'images/layout-icons/none.png',
			'title' => __( 'No Footer ', 'themify' ),
		)
	)); // default, footer-left-col, footer-right-col, footer-horizontal-left, footer-horizontal-right
}

function themify_theme_get_header_design():string {
        static $is = null;
        if($is===null){
            $is = themify_area_design( 'header', array(
                    'default' => '',
                    'values'  => wp_list_pluck( themify_theme_header_design_options(), 'value' ),
            ) );
			if($is==='none'){
				$is= 'header-none';
			}
        }
	return $is;
}

if( ! function_exists('themify_CPT_exclude_sidebar') ) {
	/**
	 * Exclude Custom Post Types
	 */
	function themify_CPT_exclude_sidebar(array $CPT = array()):array {
		$CPT[] = 'slider';
		if(themify_is_woocommerce_active()){
			$CPT[] = 'product';
		}
		return $CPT;
	}
}

if ( ! function_exists( 'themify_theme_custom_post_css' ) ) {
	/**
	 * Outputs custom post CSS in the head
	 * @since 1.0.0
	 */
	function themify_theme_custom_post_css() {
		global $themify;

		$style = '';
		$css = array();
		$rules = array();
		$post_id = get_the_ID();
		$post_type = get_post_type( $post_id );
		$header_type = themify_get( 'header_wrap' );

		if ( ! isset( $themify->google_fonts ) ) $themify->google_fonts = '';
		
		switch( $post_type ) {
			case 'product':
				$id = '.post-' . $post_id;
				$product_id = '#product-' . $post_id;
				if ( is_singular( 'product' ) ) {
					$id .= ' .product-single-top';
					$pid = '.single ' . $id;
					$product_id = '.single ' . $product_id;
				}
				else {
					$pid = $id;
					if ( 'list-post' !== $themify->post_layout )
						$id .= ' .product-bg';
					else
						$id = '.list-post ' . $id;
				}

				$rules = array(
					$id => array(
						array(	'prop' => 'background-color',
								'key' => 'background_color'
						),
						array(	'prop' => 'background-image',
								'key' => 'background_image'
						),
						array(	'prop' => 'background-repeat',
								'key' => 'background_repeat'
						),
						array(	'prop' => 'background-position',
								'key' => array('background_position_x', 'background_position_y')
						)
					),
					"$pid h3, $pid h3 a, $pid .product_title, $pid .product_title a, $pid .woocommerce-breadcrumb a, $pid .star-rating" => array(
						array(	'prop' => 'color',
								'key' => 'title_font_color'
						)
					),
					"$id .summary .price" => array(
						array(	'prop' => 'color',
								'key' => 'price_font_color'
						)
					),
					"$pid" => array(
						array(	'prop' => 'color',
								'key' => 'description_font_color'
						)
					),
					"$id .product-description a, $id .product_meta a, $id .quantity .plus, $id .quantity .minus" => array(
						array(	'prop' => 'color',
								'key' => 'link_font_color'
						)
					),
					"$pid .button.outline" => array(
						array(	'prop' => 'color',
								'key' => 'link_font_color',
								'important' => true
						),
						array(	'prop' => 'border-color',
								'key' => 'link_font_color'
						)
					),
					"$pid .single_add_to_cart_button, $pid .theme_add_to_cart_button, $pid .added_to_cart.button, $pid .quantity input.qty, $product_id .variations select" => array(
						array(	'prop' => 'color',
								'key' => 'button_font_color'
						),
						array(	'prop' => 'background-color',
								'key' => 'button_background_color'
						),
						array(	'prop' => 'border-color',
								'key' => 'button_background_color'
						),
					),
				);
				break;
			case 'slider':
				$id = '.slider-post.post-' . $post_id;
				$rules = array(
					$id => array(
						array(	'prop' => 'background-color',
								'key' => 'background_color'
						)
					),
					"$id .slide-post-title, $id .slide-post-title a" => array(
						array(	'prop' => 'color',
								'key' => 'title_font_color'
						),
						array(	'prop' => 'font-size',
								'key' => array('title_font_size', 'title_font_size_unit')
						),
						array(	'prop' => 'font-family',
								'key' => 'title_font_family'
						),
					),
					"$id .slide-excerpt" => array(
						array(	'prop' => 'color',
								'key' => 'text_font_color'
						)
					),
					"$id a" => array(
						array(	'prop' => 'color',
								'key' => 'link_font_color'
						)
					),
				);
				break;
			default:
				$id = is_page() ? ".page-id-{$post_id}" : ".postid-{$post_id}";

				if( $header_type !== 'transparent' ) {
					$rules[ $id . ' #headerwrap' ] = array(
						array(
							'prop' => 'background-color',
							'key' => 'background_color'
						),
						array(
							'prop' => 'background-image',
							'key' => 'background_image'
						),
						array(
							'prop' => 'background-repeat',
							'key' => 'background_repeat'
						),
						array(
							'prop' => 'background-position',
							'key' => array( 'background_position_x', 'background_position_y' )
						)
					);
				}

				$rules[ $id . implode( ', ' . $id, array( ' #headerwrap', ' #headerwrap .widget', ' #site-logo', ' #site-description' ) ) ] = array(
					array(
						'prop' => 'color',
						'key'  => 'headerwrap_text_color'
					),
				);

				$rules[ $id . ' #headerwrap a, ' . $id . ' #main-nav > li:hover > a:before' ] = array(
					array(
						'prop' => 'color',
						'key'  => 'headerwrap_link_color'
					),
				);

			break;
		}
		foreach ( $rules as $selector => $property ) {
			foreach ( $property as $val ) {
				$prop = $val['prop'];
				$key = $val['key'];
				if ( is_array( $key ) ) {
					if ( 'fullcover' === themify_get( $key[0] ) ) {
						continue;
					}
					if ( ($prop === 'background-position' || $prop === 'font-size') && themify_check( $key[0] ) ){
						$css[$selector][$prop] = $prop .': '. themify_get( $key[0] ) . themify_get($key[1]);
					}
				} elseif ( themify_check( $key ) && 'default' !== themify_get( $key ) ) {
					if ( 'fullcover' === themify_get( $key ) ) {
						continue;
					}
					if ( $prop === 'color' || stripos($prop, 'color')) {
						$css[$selector][$prop] = $prop .': '.themify_get_color( $key );
					}
					elseif ( $prop === 'background-image' ) {
						$img=themify_get($key);
						themify_generateWebp($img);
						$css[$selector][$prop] = $prop .': url('.$img.')';
					}
					elseif ( $prop === 'font-family' ) {
						$font = themify_get( $key );
						$css[$selector][$prop] = $prop .': '. $font;
						if ( ! in_array( $font, themify_get_web_safe_font_list( true ),true ) ) {
							$themify->google_fonts .= str_replace(' ', '+', $font.'|');
						}
					}
					else {
						$css[$selector][$prop] = $prop .': '. themify_get( $key );
					}
				}
				if ( !empty( $val['important'] ) && isset( $css[$selector][$prop] ) ) {
					$css[$selector][$prop] .= ' !important';
				}
			}
			if ( ! empty( $css[$selector] ) ) {
				$style .= "$selector {\n\t" . implode( ";\n\t", $css[$selector] ) . "\n}\n";
			}
		}

		if ( '' != $style ) {
			echo "\n<!-- $post_type-$post_id Style -->\n<style>\n$style</style>\n<!-- End $post_type-$post_id Style -->\n";
		}
	}
}
add_action( 'wp_head', 'themify_theme_custom_post_css', 77 );

/**
 * Outputs classes based on certain user-specified parameters.
 *
 * @since 1.0.0
 */

function themify_theme_loops_wrapper_class($class,$post_type,$layout,$type,$mod_settings=array(),$mod_name=false) {
    if($type!=='shortcode'){
		$is_masonry=$gutter=$content_layout=false;
		$content_layout=!in_array( $layout, array('list-large-image', 'list-thumb-image','grid2-thumb','auto_tiles'),true);
		if($type==='builder') {
			if( $mod_name==='products' || $mod_name==='post'){
				if(in_array( $layout, array('grid2', 'grid3', 'grid4','grid5','grid6'),true ) ){
					$is_masonry=isset( $mod_settings['masonry_post'] )? $mod_settings['masonry_post']==='yes':'default';
					$gutter = isset( $mod_settings['post_gutter'] )? $mod_settings['post_gutter'] : 'default';
					if($gutter==='yes' || $gutter==='no'){
						$gutter=$gutter==='yes'?false:'no-gutter';
					}
					if($is_masonry==='default'){
						$is_masonry=$mod_name==='products'?!themify_check( 'setting-shop_masonry_disabled',true  ):!themify_check( 'setting-post_masonry',true );
					}
					if($gutter==='default'){
						$gutter=$mod_name==='products'?themify_get( 'setting-product_post_gutter',false,true ) :themify_get( 'setting-post_gutter',false,true  );
					}
				}
				if($content_layout===true){
					$content_layout = isset( $mod_settings['content_layout'] )? $mod_settings['content_layout'] : 'default';
					if($content_layout==='default'){
						$content_layout=$mod_name==='products'?themify_get( 'setting-product_content_layout',false,true ):themify_get( 'setting-post_content_layout',false,true  ); 
					}
				}
			}
		}
		else{	
			if('slider' !== $layout){
				if(in_array( $layout, array('grid2', 'grid3', 'grid4','grid5','grid6'),true ) ){
					if($post_type==='product'){
					$is_masonry = themify_get_both('product_masonry','setting-shop_masonry_disabled',null);
					$gutter=themify_get_both('product_gutter','setting-product_post_gutter',false);
					$is_masonry=$is_masonry==='yes' || $is_masonry===null;
					}
					else{
					$is_masonry = themify_get_both('post_masonry','setting-post_masonry',false)==='yes';
					$gutter=themify_get_both('post_gutter','setting-post_gutter',false);
					}
				}
				$infinity = $post_type==='product'?themify_get('product_more_posts'):themify_get('more_posts');
				if($infinity!=='no'){
				$class[] = 'infinite';
				}
			}
			if($content_layout===true){
				global $themify;
				$content_layout=$post_type==='product'?themify_get_both('product_content_layout' , 'setting-product_content_layout',$themify->post_layout_type):themify_get_both('content_layout' , 'setting-post_content_layout',$themify->post_layout_type);
			}
		}
		if($is_masonry===true || $is_masonry==='yes'){
            $class[]='masonry';
            if($type!=='builder') {
                $is_masonry_align=$post_type==='product'?themify_check( 'setting-shop_masonry_align',true):themify_check( 'setting-post_masonry_align',true );
                if($is_masonry_align===true){
                    $class[]='masonry-fit-rows';
                }
            }
		}
		if($gutter==='no-gutter'){
			$class[]='no-gutter';
		}
		if($content_layout && $content_layout!=='default' && $content_layout!=='no' && $content_layout!==true){
			if($content_layout==='overlay' || $content_layout==='polaroid'){
				Themify_Enqueue_Assets::loadThemeStyleModule('post_layouts/overlay-polaroid');
			}
			else{
				Themify_Enqueue_Assets::loadThemeStyleModule('post_layouts/'.$content_layout);
			}
			$class[]=$content_layout;
		}
	}
	return $class;
}


add_filter('themify_loops_wrapper_class','themify_theme_loops_wrapper_class',10,6);

//Change comments fields position
add_filter('comment_form_fields', 'themify_reorder_comment_fields' );
function themify_reorder_comment_fields(array $fields=array() ):array{
    $new_fields = array();
    $order = array('author','email','url','comment');
    foreach( $order as $key ){
        if(isset($fields[$key])){
            $new_fields[ $key ] = $fields[ $key ];
            unset( $fields[ $key ] );
        }
    }
    if( $fields ){
        foreach( $fields as $key => $val ){
			$new_fields[ $key ] = $val;
        }
    }
    return $new_fields;
}


/**
 * Register any extra string for translation with external plugin
 */
function themify_theme_register_strings(array $strings ):array {
	$strings[] = 'setting-store_info_address';
	return $strings;
}
add_filter( 'themify_wpml_registered_strings', 'themify_theme_register_strings' );

/**
 * Announcement Bar compatibility
 *
 * @since 1.0.0
 */
function themify_theme_announcement_bar_script_vars(array $vars ):array {
	$vars['margin_top_to_bar_height'] = '#headerwrap';
	
	return $vars;
}
add_filter( 'announcement_bar_script_vars', 'themify_theme_announcement_bar_script_vars' );

/**
 * Modify the output of menu icons
 * This is applied only to the menu displayed in Icon Navigation location
 *
 * @hooked to themify_menu_icon
 * @return string
 */
function themify_theme_menu_icon( $title, $icon, $menu_item, $args, $depth ):string {
	if ( $depth === 0 ) {
        return '<em>'. themify_get_icon( $icon ) . '</em><span class="tooltip">' . $title . '</span>';
    } else {
        return '<em> '. themify_get_icon( $icon ) . '</em> ' . $title;
    }
}

/*Extend Search settings*/
if( themify_is_woocommerce_active() && 'product' === themify_get( 'setting-search_post_type','all',true )) {
	remove_action( 'pre_get_posts', 'themify_search_in_category_filter' );
	remove_filter( 'register_post_type_args', 'themify_register_post_type_args' );
}

if (!empty($_GET['type']) && in_array($_GET['type'], array('post', 'product'),true) && !is_admin()) {
    add_filter('pre_get_posts', 'themify_search_pre_get_posts', 5, 1);
}

function themify_search_pre_get_posts($query) {
    if ($query->is_main_query() && $query->is_search()) {
		remove_filter('pre_get_posts', 'themify_search_pre_get_posts', 5, 1);
        $post_type = $_GET['type'];
        $post_types = $post_type === 'post' ? array('post', 'page') : (themify_is_woocommerce_active() ? $post_type : false);
        if ($post_types) {
            if ($post_type === 'post' && ((is_array($query->post_type) && !in_array('page', $query->post_type,true)) || (themify_check('setting-search_settings_exclude',true )))) {
                $post_types = $post_type;
            }
            global $wp_post_types;
            $searchable_cpt = is_array($post_types) ? $post_types : array($post_types);
            //for builder's action do_search
            foreach ($wp_post_types as $k => &$p) {
                $p->exclude_from_search = !in_array($k, $searchable_cpt);
            }
            $query->set('post_type', $post_types);
        }
    }
    return $query;
}

//Social Banners

function themify_get_footer_banners():array {
    return apply_filters('themify_footer_banners', array(
        'twitter' => __('Twitter', 'themify'),
        'facebook' => __('Facebook', 'themify'),
        'pinterest' => __('Pinterest', 'themify'),
        'youtube' => __('Youtube', 'themify'),
        'linkedin' => __('Linkedin', 'themify'),
        'google' => __('Google+', 'themify'),
        'instagram' => __('Instagram', 'themify')
    ));
}

/**
 * Output product category count in mega menu
 *
 */
if( ! function_exists( 'themify_menu_product_category_count' ) ) :
	function themify_menu_product_category_count( $item_output, $item, $depth, $args ) {
		if(in_array($item->object,array('category','product_cat'),true)){
			$term = get_term( $item->object_id, $item->object ); // <--- tested in my system with this ID
			$item_output = str_replace('</a>','<span class="tf_post_count">'.$term->count.'</span></a>',$item_output);
		}
		return $item_output;
	}
endif;
if('on' === themify_get('setting-mega_menu_post_count',false,true)){
	add_filter( 'walker_nav_menu_start_el', 'themify_menu_product_category_count', 10, 4 );
}

function themify_theme_sticky_logo(){
	if(themify_theme_fixed_header()){
	   global $themify_customizer;
	   $logo = json_decode($themify_customizer->get_cached_mod('sticky_header_imageselect'));
	   return !empty($logo->src)?$logo:false;
	}
	return false;
}
/**
* Enable menu link highlight.
*
* @since 1.2.6
*
* @param boolean $allow.
*
* @return boolean.
*/
add_filter( 'themify_menu_highlight_link', '__return_true', 10 );

function themify_theme_load_builder_css($builder_id,$mod,$type){
    if($type==='module' && ($mod['mod_name']==='contact' || $mod['mod_name']==='product-categories' || $mod['mod_name']==='image' || $mod['mod_name']==='optin' || $mod['mod_name']==='pro-slider' || $mod['mod_name']==='fancy-heading')){
	Themify_Enqueue_Assets::loadThemeStyleModule('builder/'.$mod['mod_name']);
    }
}
add_action('themify_builder_background_styling','themify_theme_load_builder_css',10,3);

function themify_theme_get_menu_style(){
	static $is=null;
	if($is===null){
	    $is=false;
	    if (  themify_theme_show_area( 'menu_navigation' ) && themify_theme_do_not_exclude_all( 'mobile-menu' )) {
			$menu_style = themify_get_both( 'mobile_menu_styles', 'setting-mobile-menu-styles','default' );
			if ($menu_style!=='default') {
				$is=$menu_style;
			}
	    }
	}
	return $is;
}

//get Cart Style
function themify_get_cart_style() {
    static $is = null;
    if ($is===null) {
		$is = themify_is_woocommerce_active()?themify_get_both('cart_style','setting-cart_style','dropdown'):false;
    }
    return $is;
}

// Get Gallery Type 
function themify_get_gallery_type():string {
    if ( class_exists( 'Tbp_Public', false ) && is_singular( 'product' ) && Tbp_public::get_location( 'product_single' ) ) {
        /* using Builder Pro template, use WC default slider */
        return 'default';
    }
    $value = themify_get( 'setting-product_gallery_type','default',true );
    if ( $value !== 'disable-zoom' ) { /* Nov 2024 update: option is now binary choice */
        $value = 'default';
    }

    return apply_filters('themify_theme_product_gallery_type', $value );
}

function themify_mobile_menu_expand_toggle(){
    if(themify_theme_show_area( 'menu_navigation' ) && themify_theme_do_not_exclude_all( 'mobile-menu' ) && (themify_check( 'setting-mobile_menu_expand',true ) || themify_check( 'setting-mobile_menu_toggle',true ))){
        add_filter( 'themify_main_script_vars', 'themify_mobile_menu_toggle', 10 );
    }
}
add_action('wp_head','themify_mobile_menu_expand_toggle');
/**
 * Localize expand & toggle mobile menu options
 */
function themify_mobile_menu_toggle(array $vars=array()):array{
    if(themify_check( 'setting-mobile_menu_expand',true )){
        $vars['m_m_expand']=true;
    }
    if(themify_check( 'setting-mobile_menu_toggle',true )){
        $vars['m_m_toggle']=true;
    }
    return $vars;
}
if ( ! function_exists( 'themify_get_ecommerce_template' ) ) {
	/**
	 * Checks if Woocommerce is active and loads the requested template
	 * @param string $template
	 * @since 1.0.0
	 */
	function themify_get_ecommerce_template( $template = '' ) {
		if ( themify_is_woocommerce_active() )
			get_template_part( $template );
	}
}

function themify_theme_after_skin(){
    if('always'===themify_theme_dark_mode()){
        Themify_Enqueue_Assets::loadThemeStyleModule('dark-mode');
    }
}

/**
 * Check whether dark mode is enabled
 */
function themify_theme_dark_mode():string {
    static $is = null;
    if($is===null){
        $is = 'on' === themify_get( 'setting-dark_mode_enabled',null,true )? themify_get( 'setting-dark_mode_time','always',true ):'';
    }
    return $is;
}

function themify_theme_is_dark_mode():string{//backward
	return themify_theme_dark_mode();
}
/**
 * Add Skip to Content link to site
 *
 * @return string
 */
add_action('themify_body_start','themify_theme_skip_to_content');
function themify_theme_skip_to_content(){
    echo '<a class="screen-reader-text skip-to-content" href="#'.esc_attr(apply_filters('themify_skip_content_id','content')).'">'.__('Skip to content','themify').'</a>';
}

/**
 * Scripts for Themify Builder editor, adds theme-specific options for modules
 *
 * @return array
 */
function themify_theme_builder_active_vars(array $vars ):array {
	themify_enque_script( 'tb_builder-theme', THEME_URI . '/admin/js/builder-active.js', Themify_Enqueue_Assets::$themeVersion, [ 'themify-builder-app-js' ] );
	$i18n = include( THEME_DIR . '/admin/i18n.php' );
	$vars['i18n']['label'] = array_merge( $i18n, $vars['i18n']['label'] );
	$vars['theme_url'] = THEME_URI;

    return $vars;
}
add_filter( 'themify_builder_active_vars', 'themify_theme_builder_active_vars', 10, 1 );
