<?php
/***************************************************************************
 *
 *  ----------------------------------------------------------------------
 *                      DO NOT EDIT THIS FILE
 *  ----------------------------------------------------------------------
 * 
 *                       Copyright (C) Themify
 * 
 *  ----------------------------------------------------------------------
 *
 ***************************************************************************/

defined( 'ABSPATH' ) || exit;

///////////////////////////////////////////
// Social links Class
///////////////////////////////////////////
class Themify_Social_Links extends WP_Widget {
    
    ///////////////////////////////////////////
    // Feature Posts
    ///////////////////////////////////////////
    function __construct() {
        /* Widget settings. */
        $widget_ops = array( 'classname' => 'themify-social-links', 'description' => __('Social media links.', 'themify') );

        /* Widget control settings. */
        $control_ops = array( 'id_base' => 'themify-social-links' );

        /* Create the widget. */
        parent::__construct( 'themify-social-links', __('Themify - Social Links', 'themify'), $widget_ops, $control_ops );

    }

    ///////////////////////////////////////////
    // Widget
    ///////////////////////////////////////////
    function widget( $args, $instance ) {

        /** This filter is documented in wp-includes/default-widgets.php */
        $title = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );

        /* Before widget (defined by themes). */
        echo $args['before_widget'];

        if ( $title ) {
            echo $args['before_title'] , $title , $args['after_title'];
        }

        $data = themify_get_data();
        $pre = 'setting-link_';

        $field_ids = isset( $data[$pre.'field_ids'] ) ? json_decode( $data[$pre.'field_ids'] ) : '';
        
        if ( is_array( $field_ids ) || is_object( $field_ids ) ) {
            $show_link_name  = !empty( $instance['show_link_name'] );
            $new_window_attr = !empty( $instance['open_new_window'] ) ? 'target="_blank" rel="noopener"' : '';
            $icon_type = themify_get( $pre . 'icon_type','image-icon',true );

            // Icon Size
            $icon_size = !empty($instance['icon_size']) ? $instance['icon_size'] : 'icon-medium';

            // Orientation
            $orientation = !empty($instance['orientation'])? $instance['orientation'] : 'horizontal';

            echo '<ul class="social-links ' . esc_attr( $orientation ) . '">';
                foreach($field_ids as $fid){

                    $type_val = isset($data[$pre.'type_'.$fid])? $data[$pre.'type_'.$fid] : '';
                    if ( $type_val !== $icon_type ) {
                        continue;
                    }
                    
                    $title_name = $pre.'title_'.$fid;

                    $title_val = '';
                    if ( isset( $data[ $title_name ] ) ) {
                        $title_val = function_exists( 'icl_t' ) ? icl_t( 'Themify', $title_name, $data[ $title_name ] ) : $data[ $title_name ];
                    }

                    $link_name = $pre.'link_'.$fid;
                    $link_val = isset($data[$link_name])? trim( $data[$link_name] ) : '';
                    if ( '' == $link_val ) {
                        continue;
                    }

                    // Image Icon
                    $img_name = $pre.'img_'.$fid;
                    $img_val = empty( $data[$img_name] )? '' : '<img src="' . esc_url( $data[ $img_name ] ) . '" alt="'. esc_attr( $title_val ) .'" />';

                    // Font Icon
                    $font_icon = '';
                    if(!empty($data[$pre.'ficon_'.$fid])){
                        $font_icon_class=$data[$pre.'ficon_'.$fid];
                        $fi_style = '';
                        $font_icon_class = themify_get_icon( $font_icon_class,false,false,false,array('aria-label'=>esc_attr($title_val)) );
                        if ( $font_icon_color = themify_get_color( $pre.'ficolor_'.$fid,false,true ) ) {
                            $fi_style .= 'color:' . $font_icon_color . ';';
                        }
                        if ( $font_icon_bgcolor = themify_get_color( $pre.'fibgcolor_'.$fid,false,true ) ) {
                            $fi_style .= 'background-color:' . $font_icon_bgcolor . ';';
                        }
                        if ( '' !== $fi_style ) {
                            $fi_style = ' style="' . esc_attr( $fi_style ) . '"';
                        }
                        $font_icon = '<em'.$fi_style . '>'.$font_icon_class.'</em>';
                    }
                    echo sprintf('
                        <li class="social-link-item %s %s %s">
                            <a href="%s" aria-label="%s" %s>%s %s %s</a>
                        </li>
                        <!-- /themify-link-item -->',
                        sanitize_title($title_val),
                        esc_attr( $icon_type ),
                        esc_attr( $icon_size ),
                        esc_url( $link_val ),
                        sanitize_title($title_val),
                        $new_window_attr,
                        $font_icon,
                        $img_val,
                        $show_link_name? $title_val : ''
                    );
                }
            
            echo '</ul>';
        }

        /* After widget (defined by themes). */
        echo $args['after_widget'];
    }
    
    
    ///////////////////////////////////////////
    // Update
    ///////////////////////////////////////////
    function update( $new_instance, $old_instance ) {
        $instance=array();
        /* Strip tags (if needed) and update the widget settings. */
        foreach(array('show_link_name','open_new_window','icon_size','orientation') as $field){
            if(isset($new_instance[$field])){
                $instance[$field] = $new_instance[$field];
            }
        }
        if(isset($new_instance['title'])){
            $instance['title'] = strip_tags( $new_instance['title'] );
        }
        return $instance;
    }
    
    ///////////////////////////////////////////
    // Form
    ///////////////////////////////////////////
    function form( $instance ) {

        /* Set up some default widget settings. */
        $defaults = array(
            'title' => '',
            'show_link_name' => false,
            'open_new_window' => false,
            'icon_size' => 'icon-medium',
            'orientation' => 'horizontal',
        );
        $instance = wp_parse_args( (array) $instance, $defaults ); ?>
         <?php $field = esc_attr($this->get_field_id( 'title' ));?>
        <p>
                   
            <label for="<?php echo $field; ?>"><?php _e('Title:', 'themify'); ?></label><br />
            <input id="<?php echo $field; ?>" name="<?php  echo esc_attr( $this->get_field_name( 'title' ) ); ?>" value="<?php  echo esc_attr( $instance['title'] ); ?>" class="widefat" type="text" />
        </p>
                <?php $field = esc_attr($this->get_field_id( 'show_link_name' ));?>
        <p>
            <input class="checkbox" type="checkbox" <?php checked( $instance['show_link_name'], 'on' ); ?> id="<?php echo $field; ?>" name="<?php  echo esc_attr( $this->get_field_name( 'show_link_name' ) ); ?>" />
            <label for="<?php echo $field; ?>"><?php _e('Show link name', 'themify'); ?></label>
        </p>
                 <?php $field = esc_attr($this->get_field_id( 'open_new_window' ));?>
        <p>
            <input class="checkbox" type="checkbox" <?php checked( $instance['open_new_window'], 'on' ); ?> id="<?php echo $field; ?>" name="<?php  echo esc_attr( $this->get_field_name( 'open_new_window' ) ); ?>" />
            <label for="<?php echo $field; ?>"><?php _e('Open link in new window', 'themify'); ?></label>
        </p>
                 <?php $field = esc_attr($this->get_field_id( 'icon_size' ));?>
        <p>
            <label for="<?php echo $field; ?>"><?php _e('Icon Size', 'themify'); ?></label>
            <select id="<?php echo $field; ?>" name="<?php  echo esc_attr( $this->get_field_name( 'icon_size' ) ); ?>">
                <?php
                $sizes = array(
                    'icon-small' => __( 'Small', 'themify' ),
                    'icon-medium' => __( 'Medium', 'themify' ),
                    'icon-large' => __( 'Large', 'themify' ),
                );
                foreach( $sizes as $size => $name ) {
                                    echo '<option value="' . $size . '"' . selected( isset( $instance['icon_size'] )? $instance['icon_size'] : 'icon-medium', $size, false ) . '>',esc_html( $name ),'</option>';
                }
                ?>
            </select>
        </p>
                <?php $field = esc_attr($this->get_field_id( 'orientation' ));?>
        <p>
            <label for="<?php echo $field; ?>"><?php _e('Orientation', 'themify'); ?></label>
            <select id="<?php echo $field; ?>" name="<?php  echo esc_attr( $this->get_field_name( 'orientation' ) ); ?>">
                <?php
                $orientation_options = array(
                    'vertical'   => __( 'Vertical', 'themify' ),
                    'horizontal' => __( 'Horizontal', 'themify' ),
                );
                foreach( $orientation_options as $orientation => $name ) {
                    echo '<option value="' . $orientation . '"' . selected( isset( $instance['orientation'] )? $instance['orientation'] : 'horizontal', $orientation, false ) . '>',esc_html( $name ),'</option>';
                }
                ?>
            </select>
        </p>
        
        <p>
            <?php echo wp_kses_post( sprintf( __( '<small>Manage links at <a href="%s">Themify > Settings > Social Links</a>.</small>', 'themify' ), esc_url( admin_url( 'admin.php?page=themify#setting-social_links' ) ) ) ); ?>
        </p>
        <?php
    }
}

///////////////////////////////////////////
// Feature Posts Class
///////////////////////////////////////////
class Themify_Feature_Posts extends WP_Widget {
    
    ///////////////////////////////////////////
    // Feature Posts
    ///////////////////////////////////////////
    function __construct() {
        /* Widget settings. */
        $widget_ops = array( 'classname' => 'feature-posts', 'description' => __('A list of posts, optionally filter by category.', 'themify') );

        /* Widget control settings. */
        $control_ops = array( 'id_base' => 'themify-feature-posts' );

        /* Create the widget. */
        parent::__construct( 'themify-feature-posts', __('Themify - Feature Posts', 'themify'), $widget_ops, $control_ops );
    }
    /**
     * Adds aria-hidden attribute if $condition is set
     *
     * @return string|null
     */
    private static function aria_hidden( $condition, $echo = true ) {
        if( $condition ) {
            if( $echo ) {
                echo ' aria-hidden="true"';
            }
            return ' aria-hidden="true"';
        }
    }
    ///////////////////////////////////////////
    // Widget
    ///////////////////////////////////////////
    function widget( $args, $instance ) {

        extract( $args );

        /* User-selected settings. */
        $title = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );
        $category       = isset( $instance['category'] ) ? $instance['category'] : 0;
        $show_count     = isset( $instance['show_count'] ) ? $instance['show_count'] : 5;
        $show_date      = isset( $instance['show_date'] );
        $show_thumb     = isset( $instance['show_thumb'] );
        $display        = isset( $instance['display'] )? $instance['display'] : false;
        $show_excerpt   = !empty( $instance['show_excerpt'] );
        $excerpt_length = isset( $instance['excerpt_length'] ) ? $instance['excerpt_length'] : 55;
        $show_title     = !isset( $instance['hide_title'] );
        $show_read_more = isset( $instance['show_read_more'] );
        $read_more_text = empty( $instance['read_more_text'] ) ? '' : $instance['read_more_text'] ;
        $orderby        = isset( $instance['orderby'] ) ? $instance['orderby'] : 'date';
        $order          = isset( $instance['order'] ) ? $instance['order'] : 'DESC';
        $query_opts = apply_filters( 'themify_query', array(
            'posts_per_page' => $show_count,
            'post_type' => 'post',
            'orderby' => $orderby,
            'order' => $order,
            'no_found_rows'=>true,
            'ignore_sticky_posts'=>true,
            'suppress_filters' => false,
            'cache_results'=>false
        ), $instance, $this->id_base );
        if ( $category ) $query_opts['cat'] = $category;
        
        $loop = get_posts($query_opts);
        if($loop) {
            
            /* Before widget (defined by themes). */
            echo $before_widget;
            
            /* Title of widget (before and after defined by themes). */
            if ( $title ) {
                echo $args['before_title'] , $title , $args['after_title'];
            }

            echo '<ul class="feature-posts-list">';

            // Save current post
            global $post,$themify;
            if(isset($post)){
                $saved_post = clone $post;
            }
            $layout = $themify->post_layout;
            $themify->post_layout='list-post';
            if($show_thumb===true ){
                $_params=array(
                'f_image'=>true,
                'w'=>$instance['thumb_width'],
                'h'=>$instance['thumb_height'],
                'class'=>'post-img'
                );
            }
            if($show_date===true){
                $date=apply_filters( 'themify_filter_widget_date', '' );
            }
            
            foreach ($loop as $p) {
                $post=$p;
                setup_postdata($p);
                echo '<li>';

                    $link = get_post_meta( $p->ID, 'external_link', true );
                    if ( empty( $link ) ) {
                        $link = get_permalink();
                    }

                    if ( $show_thumb===true ) {
                        echo '<a href="' . esc_url( $link ) . '">',themify_get_image($_params),'</a>';
                    }
                    if ( $show_title===true ) echo '<a href="' . esc_url( $link ) . '" class="feature-posts-title">' . get_the_title() . '</a> <br />';

                    if ( $show_date===true) echo '<small>' . get_the_date( $date ) . '</small> <br />';

                    if ( $show_excerpt===true || 'excerpt' === $display ) {
                        $the_excerpt = get_the_excerpt();
                        if($excerpt_length !== '') {
                            // cut to character limit
                            $the_excerpt = substr( $the_excerpt, 0, $excerpt_length );
                            // cut to last space
                            $the_excerpt = substr( $the_excerpt, 0, strrpos( $the_excerpt, ' '));
                        }
                        echo '<span class="post-excerpt">' , wp_kses_post( $the_excerpt ) , '</span>';
                    } elseif( 'content' === $display ) {
                        echo '<div class="post-content">';
                        the_content();
                        echo '</div>';
                    }
                    if ( $show_read_more===true ) echo '<p><a href="' . esc_url( $link ) . '">' . esc_html($read_more_text) . '</a></p>';
                echo '</li>';
            } //end for each
             if ( isset( $saved_post ) ) {
                $post = $saved_post;
                setup_postdata( $saved_post );
                unset($saved_post);
            }
            $themify->post_layout=$layout;

            echo '</ul>',$after_widget;
            
        }//end if $loop
        
    }
    
    ///////////////////////////////////////////
    // Update
    ///////////////////////////////////////////
    function update( $new_instance, $old_instance ) {
        $instance = array();

        /* Strip tags (if needed) and update the widget settings. */
        foreach(array('category','show_count','show_date','show_thumb','display','hide_title','thumb_width','thumb_height','excerpt_length','show_read_more','read_more_text','orderby','order') as $v){
            if(isset($new_instance[$v])){
                $instance[$v] = $new_instance[$v];
            }
        }
        
        if(isset($new_instance['title'])){
            $instance['title'] = strip_tags( $new_instance['title'] );
        }
        return $instance;
    }
    
    ///////////////////////////////////////////
    // Form
    ///////////////////////////////////////////
    function form( $instance ) {

        /* Set up some default widget settings. */
        $defaults = array(
            'title'          => __( 'Recent Posts', 'themify' ),
            'category'       => 0,
            'show_count'     => 5,
            'show_date'      => false,
            'show_thumb'     => false,
            'display'        => 'none',
            'hide_title'     => false,
            'thumb_width'    => 50,
            'thumb_height'   => 50,
            'excerpt_length' => 55,
            'show_read_more' => false,
            'read_more_text' => __('Read more','themify'),
            'orderby' => 'date',
            'order' => 'DESC',
        );
        $instance = wp_parse_args( (array) $instance, $defaults ); ?>
        <?php $field = esc_attr($this->get_field_id( 'title' ));?>
        <p>
            <label for="<?php echo $field; ?>"><?php _e('Title:', 'themify'); ?></label><br />
            <input id="<?php echo $field; ?>" name="<?php  echo esc_attr( $this->get_field_name( 'title' ) ); ?>" value="<?php  echo esc_attr( $instance['title'] ); ?>" width="100%" />
        </p>
                <?php $field = esc_attr($this->get_field_id( 'category' ));?>
        <p>
            <label for="<?php echo $field; ?>"><?php _e('Category:', 'themify'); ?></label>
            <select id="<?php echo $field; ?>" name="<?php  echo esc_attr( $this->get_field_name( 'category' ) ); ?>">
                <option value="0" <?php if ( !$instance['category'] ) echo 'selected="selected"'; ?>><?php _e('All', 'themify'); ?></option>
                <?php
                $categories = get_categories(array('type' => 'post'));
                
                foreach( $categories as $cat ) {
                    echo '<option value="' . $cat->cat_ID . '"';
                    
                    if ( $cat->cat_ID == $instance['category'] ) echo  ' selected="selected"';
                    
                    echo '>' , esc_html( $cat->cat_name . ' (' . $cat->category_count . ')' ),'</option>';
                }
                ?>
            </select>
        </p>
                <?php $field = esc_attr($this->get_field_id( 'orderby' ));?>
        <p>
            <label for="<?php echo $field; ?>"><?php _e( 'Order By', 'themify' ); ?></label>
            <select id="<?php echo $field; ?>" name="<?php  echo esc_attr( $this->get_field_name( 'orderby' ) ); ?>">
                <?php
                $orderby_options = apply_filters( 'themify_posts_widget_orderby', array(
                        'date'          => __( 'Date (default)', 'themify' ),
                        'rand'          => __( 'Random', 'themify' ),
                        'author'        => __( 'Author', 'themify' ),
                        'title'         => __( 'Post Title', 'themify' ),
                        'comment_count' => __( 'Comments Number', 'themify' ),
                        'modified'      => __( 'Modified Date', 'themify' ),
                        'name'          => __( 'Post Slug', 'themify' ),
                        'ID'            => __( 'Post ID', 'themify' )
                    )
                );
                foreach ( $orderby_options as $criteria => $name ) {
                    echo '<option value="' . $criteria. '"' . selected( isset( $instance['orderby'] ) ? $instance['orderby'] : 'date', $criteria, false ) . '>',esc_html( $name ),'</option>';
                }
                ?>
            </select>
        </p>
                <?php $field = esc_attr($this->get_field_id( 'order' ));?>
        <p>
            <label for="<?php echo $field; ?>"><?php _e( 'Order', 'themify' ); ?></label>
            <select id="<?php echo $field; ?>" name="<?php  echo esc_attr( $this->get_field_name( 'order' ) ); ?>">
                <?php
                $order_options = array(
                    'DESC'  => __( 'Descending (default)', 'themify' ),
                    'ASC'  => __( 'Ascending', 'themify' ),
                );
                foreach ( $order_options as $criteria => $name ) {
                                    echo '<option value="' . $criteria . '"' . selected( isset( $instance['order'] ) ? $instance['order'] : 'date', $criteria, false ) . '>',esc_html( $name ),'</option>';
                }
                ?>
            </select>
        </p>
        <?php $field = esc_attr($this->get_field_id( 'show_count' ));?>
        <p>
            <label for="<?php echo $field; ?>"><?php _e('Show:', 'themify'); ?></label>
            <input id="<?php echo $field; ?>" name="<?php  echo esc_attr( $this->get_field_name( 'show_count' ) ); ?>" value="<?php  echo esc_attr( $instance['show_count'] ); ?>" size="2" /> <?php _e('posts', 'themify'); ?>
        </p>
        <?php $field = esc_attr($this->get_field_id( 'hide_title' ));?>
        <p>
            <input class="checkbox" type="checkbox" <?php checked( $instance['hide_title'], 'on' ); ?> id="<?php echo $field; ?>" name="<?php  echo esc_attr( $this->get_field_name( 'hide_title' ) ); ?>" />
            <label for="<?php echo $field; ?>"><?php _e('Hide post title', 'themify'); ?></label>
        </p>
        <?php $field = esc_attr($this->get_field_id( 'show_date' ));?>
        <p>
            <input class="checkbox" type="checkbox" <?php checked( $instance['show_date'], 'on' ); ?> id="<?php echo $field; ?>" name="<?php  echo esc_attr( $this->get_field_name( 'show_date' ) ); ?>" />
            <label for="<?php echo $field; ?>"><?php _e('Display post date', 'themify'); ?></label>
        </p>
        <?php $field = esc_attr($this->get_field_id( 'show_thumb' ));?>
        <p>
            <input class="checkbox" type="checkbox" <?php checked( $instance['show_thumb'], 'on' ); ?> id="<?php echo $field; ?>" name="<?php  echo esc_attr( $this->get_field_name( 'show_thumb' ) ); ?>" />
            <label for="<?php echo $field; ?>"><?php _e('Display post thumbnail', 'themify'); ?></label>
        </p>
        
        <?php
        // only allow thumbnail dimensions if GD library supported
        if ( function_exists('imagecreatetruecolor') ) {
                    $field = esc_attr($this->get_field_id( 'thumb_width' ));
        ?>
        <p>
           <label for="<?php echo $field; ?>"><?php _e('Thumbnail size', 'themify'); ?></label> <input type="text" id="<?php echo $field; ?>" name="<?php  echo esc_attr( $this->get_field_name( 'thumb_width' ) ); ?>" value="<?php  echo esc_attr( $instance['thumb_width'] ); ?>" size="3" /> x <input type="text" id="<?php echo esc_attr( $this->get_field_id( 'thumb_height' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'thumb_height' ) ); ?>" value="<?php echo esc_attr( $instance['thumb_height'] ); ?>" size="3" />
        </p>
        <?php
        }
        ?>
        <?php $field = esc_attr($this->get_field_id( 'display' ));?>
        <p>
            <label for="<?php echo $field; ?>"><?php _e('Display:', 'themify'); ?></label>
            <select id="<?php echo $field; ?>" name="<?php  echo esc_attr( $this->get_field_name( 'display' ) ); ?>">
                <?php
                foreach( array(
                    'none' => __('None', 'themify'),
                    'content' => __('Content', 'themify'),
                    'excerpt' => __('Excerpt', 'themify')
                ) as $key => $title ) {
                    echo '<option value="' . $key . '" '.selected($key, $instance['display'], false).' >' , esc_html( $title ) , '</option>';
                }
                ?>
            </select>
        </p>
        <?php $field = esc_attr($this->get_field_id( 'excerpt_length' ));?>
        <p>
            <label for="<?php echo $field; ?>"><?php _e('Excerpt character limit:', 'themify'); ?></label>
            <input id="<?php echo $field; ?>" name="<?php echo esc_attr( $this->get_field_name( 'excerpt_length' ) ); ?>" value="<?php  echo esc_attr( $instance['excerpt_length'] ); ?>" size="5" /><br /><small><?php _e('(leave empty = full excerpt)', 'themify'); ?></small>
        </p>
        <?php $field = esc_attr($this->get_field_id( 'show_read_more' ));?>
        <p>
            <input class="checkbox themify_featured_posts_read_more" type="checkbox" <?php checked( $instance['show_read_more'], 'on' ); ?> id="<?php echo $field; ?>" name="<?php  echo esc_attr( $this->get_field_name( 'show_read_more' ) ); ?>" />
            <label for="<?php echo $field; ?>"><?php _e('Display read more link', 'themify'); ?></label>
        </p>
        <?php $field = esc_attr($this->get_field_id( 'read_more_text' ));?>
        <p>
            <label for="<?php echo $field; ?>"><?php _e('Read More Text:', 'themify'); ?></label> 
            <input id="<?php echo $field; ?>" name="<?php  echo esc_attr( $this->get_field_name( 'read_more_text' ) ); ?>" value="<?php echo esc_attr( $instance['read_more_text'] ); ?>" />
        </p>
        <?php
    }
}

///////////////////////////////////////////
// List Pages Class
///////////////////////////////////////////
class Themify_List_Pages extends WP_Widget {
    
    ///////////////////////////////////////////
    // List Pages
    ///////////////////////////////////////////
    function __construct() {
        /* Widget settings. */
        $widget_ops = array( 'classname' => 'list-pages', 'description' => __('A list of pages', 'themify') );

        /* Widget control settings. */
        $control_ops = array( 'id_base' => 'themify-list-pages' );

        /* Create the widget. */
        parent::__construct( 'themify-list-pages', __('Themify - List Pages', 'themify'), $widget_ops, $control_ops );
    }
    
    ///////////////////////////////////////////
    // Widget
    ///////////////////////////////////////////
    function widget( $args, $instance ) {
        extract( $args );

        /* User-selected settings. */
        $title = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );
        $parent = isset( $instance['parent'] ) ? $instance['parent'] : '';
        $depth = isset( $instance['depth'] ) ? $instance['depth'] : 0;
        $orderby = isset( $instance['orderby'] ) ? $instance['orderby'] : false;
        $exclude = isset( $instance['exclude'] ) ? $instance['exclude'] : false;

        /* Before widget (defined by themes). */
        echo $before_widget;

        /* Title of widget (before and after defined by themes). */
        if ( $title ) {
            echo $args['before_title'] , $title , $args['after_title'];
        }
        
        echo '<ul class="pages-list">';
        
        wp_list_pages(array(
            'child_of'       => $parent,
            'depth'         => $depth,
            'sort_column'   => $orderby,
            'exclude'  => $exclude,
            'title_li' => ''
        ));
        
        echo '</ul>',$after_widget;
    }
    
    ///////////////////////////////////////////
    // Update
    ///////////////////////////////////////////
    function update( $new_instance, $old_instance ) {
        $instance=array();
        foreach(array('parent','depth','orderby','exclude') as $field){
            if(isset($new_instance[$field])){
                $instance[$field] = $new_instance[$field];
            }
        }
        /* Strip tags (if needed) and update the widget settings. */
        if(isset($new_instance['title'])){
            $instance['title'] = strip_tags( $new_instance['title'] );
        }

        return $instance;
    }
    
    ///////////////////////////////////////////
    // Form
    ///////////////////////////////////////////
    function form( $instance ) {

        /* Set up some default widget settings. */
        $defaults = array( 
            'title' => __('Pages', 'themify'),
            'parent' => '',
            'depth' => 0,
            'orderby' => 'post_title',
            'exclude' => ''
            );
        $instance = wp_parse_args( (array) $instance, $defaults ); 
                $field = esc_attr($this->get_field_id( 'title' ));?>
        <p>
            <label for="<?php echo $field; ?>"><?php _e('Title:', 'themify'); ?></label><br />
            <input id="<?php echo $field; ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" value="<?php echo esc_attr( $instance['title'] ); ?>" width="100%" />
        </p>
                <?php $field = esc_attr($this->get_field_id( 'parent' ));?>
        <p>
            <label for="<?php echo $field; ?>"><?php _e('Parent:', 'themify'); ?></label>
            <select id="<?php echo $field; ?>" name="<?php echo esc_attr( $this->get_field_name( 'parent' ) ); ?>">
                <option value="0" <?php if ( 0 == $instance['parent'] ) echo 'selected="selected"'; ?>>All</option>
                <?php
                $pages = get_pages();
                
                foreach( $pages as $thepage ) {
                    echo '<option value="' . $thepage->ID . '"';
                    
                    if ( $thepage->ID == $instance['parent'] ) echo ' selected="selected"';
                    
                    echo '>',esc_html( $thepage->post_title ),'</option>';
                }
                ?>
            </select>
        </p>
        <?php $field = esc_attr($this->get_field_id( 'depth' ));?>
        <p>
            <label for="<?php echo $field; ?>"><?php _e('Depth:', 'themify'); ?></label>
            <select id="<?php echo $field; ?>" name="<?php echo esc_attr( $this->get_field_name( 'depth' ) ); ?>">
                <option value="0" <?php if ( 0 == $instance['depth'] ) echo 'selected="selected"'; ?>><?php _e('0 (default)', 'themify'); ?></option>
                <option value="1" <?php if ( 1 == $instance['depth'] ) echo 'selected="selected"'; ?>>1</option>
                <option value="2" <?php if ( 2 == $instance['depth'] ) echo 'selected="selected"'; ?>>2</option>
                <option value="3" <?php if ( 3 == $instance['depth'] ) echo 'selected="selected"'; ?>>3</option>
                <option value="4" <?php if ( 4 == $instance['depth'] ) echo 'selected="selected"'; ?>>4</option>
            </select>
        </p>
        <?php $field = esc_attr($this->get_field_id( 'orderby' ));?>
        <p>
            <label for="<?php echo $field; ?>"><?php _e('Sort By:', 'themify'); ?></label>
            <select id="<?php echo $field; ?>" name="<?php echo esc_attr( $this->get_field_name( 'orderby' ) ); ?>">
                <option value="id" <?php if ( 'id' === $instance['orderby'] ) echo 'selected="selected"'; ?>>ID</option>
                <option value="menu_order" <?php if ( 'menu_order' === $instance['orderby'] ) echo 'selected="selected"'; ?>><?php _e('Menu Order', 'themify'); ?></option>
                <option value="post_title" <?php if ( 'post_title' === $instance['orderby'] ) echo 'selected="selected"'; ?>><?php _e('Post Title', 'themify'); ?></option>
                <option value="post_date" <?php if ( 'post_date' === $instance['orderby'] ) echo 'selected="selected"'; ?>><?php _e('Post Date', 'themify'); ?></option>
                <option value="post_name" <?php if ( 'post_name' === $instance['orderby'] ) echo 'selected="selected"'; ?>><?php _e('Post Name', 'themify'); ?></option>
            </select>
        </p>
        <?php $field = esc_attr($this->get_field_id( 'exclude' ));?>
        <p>
            <label for="<?php echo $field; ?>"><?php _e('Exclude:', 'themify'); ?></label><br />
            <input id="<?php echo $field; ?>" name="<?php echo esc_attr( $this->get_field_name( 'exclude' ) ); ?>" value="<?php echo esc_attr( $instance['exclude'] ); ?>" /><br />
            <small><?php _e('Page IDs, separated by commas (eg. 5,8)', 'themify'); ?></small>
        </p>
        <?php
    }
}

///////////////////////////////////////////
// List Categories Class
///////////////////////////////////////////
class Themify_List_Categories extends WP_Widget {
    
    ///////////////////////////////////////////
    // List Categories
    ///////////////////////////////////////////
    function __construct() {
        /* Widget settings. */
        $widget_ops = array( 'classname' => 'list-categories', 'description' => __('A list of categories', 'themify') );

        /* Widget control settings. */
        $control_ops = array( 'id_base' => 'themify-list-categories' );

        /* Create the widget. */
        parent::__construct( 'themify-list-categories', __('Themify - List Categories', 'themify'), $widget_ops, $control_ops );
    }
    
    ///////////////////////////////////////////
    // Widget
    ///////////////////////////////////////////
    function widget( $args, $instance ) {
        extract( $args );

        $themify_this_widget_id_pre = isset( $args['widget_id'] ) ? $args['widget_id'] : '';
        $themify_widget_id = $themify_this_widget_id_pre . '-cats';

        /* User-selected settings. */
        $title = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );
        $parent = isset( $instance['parent'] ) ? $instance['parent'] : null;
        $depth = isset( $instance['depth'] ) ? $instance['depth'] : null;
        $orderby = isset( $instance['orderby'] ) ? $instance['orderby'] : null;
        $exclude = isset( $instance['exclude'] ) ? $instance['exclude'] : null;
        $show_dropdown = isset( $instance['show_dropdown'] ) ? $instance['show_dropdown'] : false;
        $show_counts = isset( $instance['show_counts'] ) ? $instance['show_counts'] : false;
        $show_hierarchy = isset( $instance['show_hierarchy'] ) ? $instance['show_hierarchy'] : false;

        /* Before widget (defined by themes). */
        echo $before_widget;

        /* Title of widget (before and after defined by themes). */
        if ( $title ) {
            echo $args['before_title'] , $title , $args['after_title'];
        }

        $args = array(
                'orderby'       => $orderby,
                'show_count'    => $show_counts,
                'child_of'      => $parent,
                'exclude'       => $exclude,
                'hierarchical'  => $show_hierarchy,
                'depth'         => $depth,
                'title_li'      => '',
                'id'            => $themify_widget_id
            );

        if ( $show_dropdown ) {
            $args['show_option_none'] = __('Select Category', 'themify');
            wp_dropdown_categories($args);
        ?>
        
            <script type='text/javascript'>
            /* <![CDATA[ */
                function onCatChange() {
                    var dropdown = document.getElementById('<?php echo esc_js( $themify_widget_id ); ?>'),
                        catSelected = dropdown.options[dropdown.selectedIndex].value;
                    if ( catSelected > 0 ) {
                        location.href = "<?php echo home_url(); ?>/?cat="+catSelected;
                    }
                }
                document.getElementById('<?php echo esc_js( $themify_widget_id ); ?>').onchange = onCatChange;
            /* ]]> */
            </script>
        
        <?php
        }
        else {
            echo '<ul class="categories-list">';
            
            wp_list_categories($args);
            
            echo '</ul>';
        }

        /* After widget (defined by themes). */
        echo $after_widget;
    }
    
    ///////////////////////////////////////////
    // Update
    ///////////////////////////////////////////
    function update( $new_instance, $old_instance ) {
        
        $instance=array();
        /* Strip tags (if needed) and update the widget settings. */
        foreach(array('parent','depth','orderby','exclude','show_dropdown','show_counts','show_hierarchy') as $field){
            if(isset($new_instance[$field])){
                $instance[$field] = $new_instance[$field];
            }
        }
        if(isset($new_instance['title'])){
            $instance['title'] = strip_tags( $new_instance['title'] );
        }
        return $instance;
    }
    
    ///////////////////////////////////////////
    // Form
    ///////////////////////////////////////////
    function form( $instance ) {

        /* Set up some default widget settings. */
        $defaults = array( 'title' => __('Categories', 'themify'), 'parent' => 0, 'depth' => 0, 'orderby' => 'name', 'exclude' => '', 'show_dropdown' => false, 'show_counts' => false, 'show_hierarchy' => true );
        $instance = wp_parse_args( (array) $instance, $defaults );
                $field = esc_attr($this->get_field_id( 'title' ));
                ?>
        <p>
                    <label for="<?php echo $field; ?>"><?php _e('Title:', 'themify'); ?></label><br />
                    <input id="<?php echo $field; ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" value="<?php echo esc_attr( $instance['title'] ); ?>" width="100%" />
        </p>
                <?php $field = esc_attr($this->get_field_id( 'parent' ));?>
        <p>
            <label for="<?php echo $field; ?>"><?php _e('Parent:', 'themify'); ?></label>
            <?php
            wp_dropdown_categories( array(
                'show_option_all' => __('All', 'themify'),
                'orderby'         => 'name',
                'hierarchical'    => 1,
                'selected'        => $instance['parent'],
                'id'              => $field,
                'name'            => $this->get_field_name( 'parent' ),
            ));
            ?>
        </p>
                <?php $field = esc_attr($this->get_field_id( 'depth' ));?>
        <p>
            <label for="<?php echo $field; ?>"><?php _e('Depth:', 'themify'); ?></label>
            <select id="<?php echo $field; ?>" name="<?php echo esc_attr( $this->get_field_name( 'depth' ) ); ?>">
                <option value="0" <?php if ( 0 == $instance['depth'] ) echo 'selected="selected"'; ?>><?php _e('0 (default)', 'themify'); ?></option>
                <option value="1" <?php if ( 1 == $instance['depth'] ) echo 'selected="selected"'; ?>>1</option>
                <option value="2" <?php if ( 2 == $instance['depth'] ) echo 'selected="selected"'; ?>>2</option>
                <option value="3" <?php if ( 3 == $instance['depth'] ) echo 'selected="selected"'; ?>>3</option>
                <option value="4" <?php if ( 4 == $instance['depth'] ) echo 'selected="selected"'; ?>>4</option>
            </select>
        </p>
        <?php $field = esc_attr($this->get_field_id( 'orderby' ));?>
        <p>
            <label for="<?php echo $field; ?>"><?php _e('Orderby:', 'themify'); ?></label>
            <select id="<?php echo $field; ?>" name="<?php echo esc_attr( $this->get_field_name( 'orderby' ) ); ?>">
                <option value="id" <?php if ( 'id' === $instance['orderby'] ) echo 'selected="selected"'; ?>><?php _e( 'ID', 'themify' ); ?></option>
                <option value="name" <?php if ( 'name' === $instance['orderby'] ) echo 'selected="selected"'; ?>><?php _e( 'Name', 'themify' ); ?></option>
                <option value="slug" <?php if ( 'slug' === $instance['orderby'] ) echo 'selected="selected"'; ?>><?php _e( 'Slug', 'themify' ); ?></option>
                <option value="count" <?php if ( 'count' === $instance['orderby'] ) echo 'selected="selected"'; ?>><?php _e('Count', 'themify'); ?></option>
            </select>
        </p>
        <?php $field = esc_attr($this->get_field_id( 'exclude' ));?>
        <p>
            <label for="<?php echo $field; ?>"><?php _e('Exclude:', 'themify'); ?></label><br />
            <input id="<?php echo $field; ?>" name="<?php echo esc_attr( $this->get_field_name( 'exclude' ) ); ?>" value="<?php echo esc_attr( $instance['exclude'] ); ?>" /><br />
            <small><?php _e('Category IDs, separated by commas (eg. 5,8)', 'themify'); ?></small>
        </p>
        <?php $field = esc_attr($this->get_field_id( 'show_dropdown' ));?>
        <p>
            <input class="checkbox" type="checkbox" <?php checked( $instance['show_dropdown'], 'on' ); ?> id="<?php echo $field; ?>" name="<?php echo esc_attr( $this->get_field_name( 'show_dropdown' ) ); ?>" />
            <label for="<?php echo $field; ?>"><?php _e('Show as dropdown', 'themify'); ?></label>
        </p>
        <?php $field = esc_attr($this->get_field_id( 'show_counts' ));?>
        <p>
            <input class="checkbox" type="checkbox" <?php checked( $instance['show_counts'], 'on' ); ?> id="<?php echo $field; ?>" name="<?php echo esc_attr( $this->get_field_name( 'show_counts' ) ); ?>" />
            <label for="<?php echo $field; ?>"><?php _e('Show post counts', 'themify'); ?></label>
        </p>
        <?php $field = esc_attr($this->get_field_id( 'show_hierarchy' ));?>
        <p>
            <input class="checkbox" type="checkbox" <?php checked( $instance['show_hierarchy'], 'on' ); ?> id="<?php echo $field; ?>" name="<?php echo esc_attr( $this->get_field_name( 'show_hierarchy' ) ); ?>" />
            <label for="<?php echo $field; ?>"><?php _e('Show hierarchy', 'themify'); ?></label>
        </p>
        <?php
    }
}

///////////////////////////////////////////
// Recent Comments Class
///////////////////////////////////////////
class Themify_Recent_Comments extends WP_Widget {
    
    ///////////////////////////////////////////
    // Recent Comments
    ///////////////////////////////////////////
    function __construct() {
        /* Widget settings. */
        $widget_ops = array( 'classname' => 'recent-comments', 'description' => __('A list of recent comments from all posts', 'themify') );

        /* Widget control settings. */
        $control_ops = array( 'id_base' => 'themify-recent-comments' );

        /* Create the widget. */
        parent::__construct( 'themify-recent-comments', __('Themify - Recent Comments', 'themify'), $widget_ops, $control_ops );
    }
    
    ///////////////////////////////////////////
    // Widget
    ///////////////////////////////////////////
    function widget( $args, $instance ) {
        extract( $args );

        /* User-selected settings. */
        $title = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );
        $show_count = isset( $instance['show_count'] ) ? $instance['show_count'] : 3;
        $show_avatar = isset( $instance['show_avatar'] ) ? $instance['show_avatar'] : false;
        $avatar_size = isset( $instance['avatar_size'] ) ? $instance['avatar_size'] : 32;
        $excerpt_length = isset( $instance['excerpt_length'] ) ? $instance['excerpt_length'] : 60;

        $comments = get_comments(array(
            'number' => $show_count,
            'status' => 'approve',
            'type' => 'comment'
        ));
        if($comments){
        
            /* Before widget (defined by themes). */
            echo $before_widget;
    
            /* Title of widget (before and after defined by themes). */
            if ( $title ) {
                echo $args['before_title'] , $title , $args['after_title'];
            }
            echo '<ul class="recent-comments-list">';
            
            foreach($comments as $comment){
                $p = get_post($comment->comment_post_ID);
                if( ! empty( $p->post_password ) ) continue;
                $comm_title = get_the_title($comment->comment_post_ID);
                $comm_link = get_comment_link($comment->comment_ID);
                ?>
            
                <li>
                    <?php
                        if ( $show_avatar ) {
                            echo '<a href="' . esc_url( $comm_link ) . '">' . get_avatar($comment,$size=$avatar_size, '', sprintf( __( 'Avatar of %s', 'themify' ), $comment->comment_author ) ) . '</a>';
                        }
                        $comment_text = get_comment_excerpt( $comment->comment_ID );
                        if(0 != $excerpt_length) {
                            $last = substr( substr( $comment_text , 0, $excerpt_length), -1);
                            if ( strlen(count_chars($comment_text, 3)) > $excerpt_length ) {
                                $comment_text = substr( $comment_text , 0, $excerpt_length - 1) . preg_replace('/[^(\x00-\x7F)]*/','', $last);
                            } else {
                                $comment_text = substr( $comment_text , 0, $excerpt_length - 1);
                            }
                        }
                    ?>
                    <a href="<?php echo esc_url( $comm_link );?>"><strong class="comment-author"><?php echo wp_kses_data( $comment->comment_author ); ?></strong>:</a> <?php echo wp_kses_data( $comment_text ); ?>&hellip;
                </li> 
            
                <?php 
            }
            
            echo '</ul>',$after_widget;
        }//end if $comments
    }
    
    ///////////////////////////////////////////
    // Update
    ///////////////////////////////////////////
    function update( $new_instance, $old_instance ) {
        $instance = array();

        /* Strip tags (if needed) and update the widget settings. */
        if(isset($new_instance['title'])){
            $instance['title'] = strip_tags( $new_instance['title'] );
        }
        foreach(array('show_count','show_avatar','avatar_size','excerpt_length') as $v){
            if(isset($new_instance[$v])){
                $instance[$v] = $new_instance[$v];
            }
        }
        return $instance;
    }
    
    ///////////////////////////////////////////
    // Form
    ///////////////////////////////////////////
    function form( $instance ) {

        /* Set up some default widget settings. */
        $defaults = array(
            'title' => __('Recent Comments', 'themify'),
            'show_count' => 3, 
            'show_avatar' => false, 
            'avatar_size' => 32,
            'excerpt_length' => 60
            );
        $instance = wp_parse_args( (array) $instance, $defaults ); 
                $field = esc_attr($this->get_field_id( 'title' ));
                ?>
        <p>
            <label for="<?php echo $field; ?>"><?php _e('Title:', 'themify'); ?></label><br />
            <input id="<?php echo $field; ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" value="<?php echo esc_attr( $instance['title'] ); ?>" width="100%" />
        </p>
                <?php $field = esc_attr($this->get_field_id( 'show_count' ));?>
        <p>
            <label for="<?php echo $field; ?>"><?php _e('Show:', 'themify'); ?></label>
            <select id="<?php echo $field; ?>" name="<?php echo esc_attr( $this->get_field_name( 'show_count' ) ); ?>">
                <?php
                for ( $i = 1; $i < 11; ++$i ) {
                    echo '<option' . ( $i == $instance['show_count'] ? ' selected="selected"' : '' ) . '>' , $i , '</option>';
                }
                ?>
            </select>
        </p>
        <?php $field = esc_attr($this->get_field_id( 'avatar' ));?>
        <p>
            <input class="checkbox" type="checkbox" <?php checked( $instance['show_avatar'], 'on' ); ?> id="<?php echo $field; ?>" name="<?php echo esc_attr( $this->get_field_name( 'show_avatar' ) ); ?>" />
            <label for="<?php echo $field; ?>"><?php _e('Show avatar', 'themify'); ?></label>
        </p>
        <?php $field = esc_attr($this->get_field_id( 'avatar_size' ));?>
        <p>
            <label for="<?php echo $field; ?>"><?php _e('Avatar size:', 'themify'); ?></label>
            <input id="<?php echo $field; ?>" name="<?php echo esc_attr( $this->get_field_name( 'avatar_size' ) ); ?>" value="<?php echo esc_attr( $instance['avatar_size'] ); ?>" size="4" /> px
        </p>
        <?php $field = esc_attr($this->get_field_id( 'excerpt_length' ));?>
        <p>
            <label for="<?php echo $field; ?>"><?php _e('Comment excerpt:', 'themify'); ?></label>
            <input id="<?php echo $field; ?>" name="<?php echo esc_attr( $this->get_field_name( 'excerpt_length' ) ); ?>" value="<?php echo esc_attr( $instance['excerpt_length'] ); ?>" size="4" /> <?php _e('characters', 'themify'); ?>
        </p>
        <?php
    }
}

///////////////////////////////////////////
// Banners & Links Class
///////////////////////////////////////////
if ( get_option( 'link_manager_enabled' ) ) :
class Themify_Links extends WP_Widget {
    
    ///////////////////////////////////////////
    // Themify Links
    ///////////////////////////////////////////
    function __construct() {
        /* Widget settings. */
        $widget_ops = array( 'classname' => 'links', 'description' => __('A list of bookmarks', 'themify') );

        /* Widget control settings. */
        $control_ops = array( 'id_base' => 'themify-links' );

        /* Create the widget. */
        parent::__construct( 'themify-links', __('Themify - Banners &amp; Links', 'themify'), $widget_ops, $control_ops );
    }
    
    ///////////////////////////////////////////
    // Widget
    ///////////////////////////////////////////
    function widget( $args, $instance ) {
        extract( $args );

        /* User-selected settings. */
        $title = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );
        $category = isset( $instance['category'] ) ? $instance['category'] : '';
        $orderby = isset( $instance['orderby'] ) ? $instance['orderby'] : 'rand';
        $show_count = isset( $instance['show_count'] ) ? $instance['show_count'] : '';
        $show_thumb = isset( $instance['show_thumb'] ) ? $instance['show_thumb'] : false;
        $show_name = isset( $instance['show_name'] ) ? $instance['show_name'] : false;
        $show_desc = isset( $instance['show_desc'] ) ? $instance['show_desc'] : false;

        /* Before widget (defined by themes). */
        echo $before_widget;

        /* Title of widget (before and after defined by themes). */
        if ( $title ) {
            echo $args['before_title'] , $title , $args['after_title'];
        }
        
        echo '<ul class="links-list">';
        
        wp_list_bookmarks( array(
            'categorize'        => false,
            'title_li'          => false,
            'orderby'           => $orderby,
            'limit'             => $show_count,
            'category'          => $category,
            'show_images'       => $show_thumb,
            'show_name'         => $show_name,
            'show_description'  => $show_desc
        ));
        
        echo '</ul>',$after_widget;
    }
    
    ///////////////////////////////////////////
    // Update
    ///////////////////////////////////////////
    function update( $new_instance, $old_instance ) {
        $instance = array();

        foreach(array('category','orderby','show_count','show_thumb','show_name','show_desc') as $v){
            if(isset($new_instance[$v])){
                $instance[$v] = $new_instance[$v];
            }
        }
        /* Strip tags (if needed) and update the widget settings. */
        if(isset($new_instance['title'])){
            $instance['title'] = strip_tags( $new_instance['title'] );
        }
        return $instance;
    }
    
    ///////////////////////////////////////////
    // Form
    ///////////////////////////////////////////
    function form( $instance ) {

        /* Set up some default widget settings. */
        $defaults = array( 'title' => __('Blogroll', 'themify'), 'category' => '', 'orderby' => 'rand', 'show_count' => 10, 'show_thumb' => false, 'show_name' => false, 'show_desc' => false );
        $instance = wp_parse_args( (array) $instance, $defaults ); 
                $field = esc_attr($this->get_field_id( 'title' ));
                ?>
        <p>
            <label for="<?php echo $field; ?>"><?php _e('Title:', 'themify'); ?></label><br />
            <input id="<?php echo $field; ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" value="<?php echo esc_attr( $instance['title'] ); ?>" width="100%" />
        </p>
                <?php $field = esc_attr($this->get_field_id( 'category' ));?>
        <p>
            <label for="<?php echo $field; ?>"><?php _e('Category:', 'themify'); ?></label>
            <select id="<?php echo $field; ?>" name="<?php echo esc_attr( $this->get_field_name( 'category' ) ); ?>">
                <option value="" <?php if ( '' == $instance['category'] ) echo 'selected="selected"'; ?>>All</option>
                <?php
                $categories = get_categories(array('type' => 'link'));
                
                foreach( $categories as $cat ) {
                    echo '<option value="' . $cat->cat_ID . '"';
                    
                    if ( $cat->cat_ID == $instance['category'] ) echo  ' selected="selected"';
                    
                    echo '>' , esc_html( $cat->cat_name . ' (' . $cat->category_count . ')' ),'</option>';
                }
                ?>
            </select>
        </p>
        <?php $field = esc_attr($this->get_field_id( 'orderby' ));?>
        <p>
            <label for="<?php echo $field; ?>"><?php _e('Orderby:', 'themify'); ?></label>
            <select id="<?php echo $field; ?>" name="<?php echo esc_attr( $this->get_field_name( 'orderby' ) ); ?>">
                <option value="id" <?php if ( 'id' === $instance['orderby'] ) echo 'selected="selected"'; ?>><?php _e('ID', 'themify'); ?></option>
                <option value="name" <?php if ( 'name' === $instance['orderby'] ) echo 'selected="selected"'; ?>><?php _e('Name', 'themify'); ?></option>
                <option value="rating" <?php if ( 'rating' === $instance['orderby'] ) echo 'selected="selected"'; ?>><?php _e('Rating', 'themify'); ?></option>
                <option value="rand" <?php if ( 'rand' === $instance['orderby'] ) echo 'selected="selected"'; ?>><?php _e('Random', 'themify'); ?></option>
            </select>
        </p>
        <?php $field = esc_attr($this->get_field_id( 'show_count' ));?>
        <p>
            <label for="<?php echo $field; ?>"><?php _e('Limit:', 'themify'); ?></label>
            <input id="<?php echo $field; ?>" name="<?php echo esc_attr( $this->get_field_name( 'show_count' ) ); ?>" value="<?php echo esc_attr( $instance['show_count'] ); ?>" size="2" />
        </p>
        <?php $field = esc_attr($this->get_field_id( 'show_thumb' ));?>
        <p>
            <input class="checkbox" type="checkbox" <?php checked( $instance['show_thumb'], 'on' ); ?> id="<?php echo $field; ?>" name="<?php echo esc_attr( $this->get_field_name( 'show_thumb' ) ); ?>" />
            <label for="<?php echo $field; ?>"><?php _e('Show link image', 'themify'); ?></label>
        </p>
        <?php $field = esc_attr($this->get_field_id( 'show_name' ));?>
        <p>
            <input class="checkbox" type="checkbox" <?php checked( $instance['show_name'], 'on' ); ?> id="<?php echo $field; ?>" name="<?php echo esc_attr( $this->get_field_name( 'show_name' ) ); ?>" />
            <label for="<?php echo $field; ?>"><?php _e('Show link name', 'themify'); ?></label>
        </p>
        <?php $field = esc_attr($this->get_field_id( 'show_desc' ));?>
        <p>
            <input class="checkbox" type="checkbox" <?php checked( $instance['show_desc'], 'on' ); ?> id="<?php echo $field; ?>" name="<?php echo esc_attr( $this->get_field_name( 'show_desc' ) ); ?>" />
            <label for="<?php echo $field; ?>"><?php _e('Show link description', 'themify'); ?></label>
        </p>
        <?php
    }
}
endif;

/**
 * @package themify
 * @subpackage Widgets
 * @access public
 * @since 1.1.2
 */
class Themify_Most_Commented extends WP_Widget{
    
    function __construct(){
        $widget_ops = array( 'classname' => 'themify-most-commented', 'description' => __('A list with the most commented posts.', 'themify') );
        $control_ops = array( 'id_base' => 'themify-most-commented' );
        parent::__construct( 'themify-most-commented', __('Themify - Most Commented', 'themify'), $widget_ops, $control_ops );
    }
    
    function widget( $args, $instance ) {

        extract( $args );

        $title = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );
        $show_count = isset( $instance['show_count'] ) ? $instance['show_count'] : 10;
        $show_excerpt = isset( $instance['show_excerpt'] ) ? $instance['show_excerpt'] : false;
        $show_thumb = isset( $instance['show_thumb'] ) ? $instance['show_thumb'] : false;
        $thumb_width = isset( $instance['thumb_width'] ) ? $instance['thumb_width'] : 50;
        $thumb_height = isset( $instance['thumb_height'] ) ? $instance['thumb_height'] : 50;
        $excerpt_length = isset( $instance['excerpt_length'] ) ? $instance['excerpt_length'] : 55;
        $hide_title = isset( $instance['hide_title'] ) ? $instance['hide_title'] : false;
        $show_comment_count = isset( $instance['show_comment_count'] ) ? $instance['show_comment_count'] : false;

        $loop = get_posts( array(
            'numberposts' => $show_count,
            'orderby' => 'comment_count',
            'post_type' => 'post',
            'order' => 'DESC',
            'ignore_sticky_posts'=>true,
            'suppress_filters' => false,
            'cache_results'=>false
        ) );

        if ( $loop ) {
            
            /* Before widget (defined by themes). */
            echo $before_widget;
            
            /* Title of widget (before and after defined by themes). */
            if ( $title ) {
                echo $args['before_title'] , $title , $args['after_title'];
            }   
        
            echo '<ul class="feature-posts-list">';
            global $post;
            foreach ( $loop as $post ) {
                setup_postdata( $post );
                
                echo '<li>';
                
                if ( $show_thumb ) {
                    echo themify_get_image( [
                        'w' => $thumb_width,
                        'h' => $thumb_height,
                        'before' => '<a href="' . esc_url( get_permalink() ) . '">',
                        'after' => '</a>',
                        'class' => 'post-img'
                    ] );
                }

                if( !$hide_title ){
                    echo '<a href="' . esc_url( get_permalink() ) . '" class="feature-posts-title">' , get_the_title() , '</a>';
                }
                
                if ( $show_comment_count ){
                    $comment_string = (get_comments_number() > 1)? __('comments', 'themify') : __('comment', 'themify');
                    echo '<br/><small>' , get_comments_number() , ' ' , $comment_string , '</small> <br />';
                }
                if ( $show_excerpt ) {
                    $the_excerpt = get_the_excerpt();

                    if ( $excerpt_length != '' ) {
                        // cut to character limit
                        $the_excerpt = substr( $the_excerpt, 0, $excerpt_length );

                        // cut to last space
                        $the_excerpt = substr( $the_excerpt, 0, strrpos( $the_excerpt, ' ' ) );
                    }
                    
                    echo '<span class="post-excerpt">' , wp_kses_post( $the_excerpt ) , '</span>';
                }
                    
                echo '</li>';
                wp_reset_postdata();
            }
            echo '</ul>',$after_widget;
        }
        
    }
    
    function update( $new_instance, $old_instance ){
        $instance = array();
        /* Strip tags (if needed) and update the widget settings. */
        if(isset($new_instance['title'])){
            $instance['title'] = strip_tags( $new_instance['title'] );
        }
        foreach(array('show_count','show_thumb','show_thumb','thumb_width','thumb_height','show_excerpt','excerpt_length','hide_title','show_comment_count') as $v){
            if(isset($new_instance[$v])){
                $instance[$v] = $new_instance[$v];
            }
        }
        return $instance;
    }
    
    function form( $instance ) {

        /* Set up some default widget settings. */
        $defaults = array(
            'title' => __('Most Commented Posts', 'themify'),
            'show_count' => 5,
            'show_excerpt'  => false,
            'show_thumb' => false,
            'thumb_width' => 50,
            'thumb_height' => 50,
            'excerpt_length' => 55,
            'hide_title' => false,
            'show_comment_count' => false
        );
        
        $instance = wp_parse_args( (array) $instance, $defaults );
                $field = esc_attr($this->get_field_id( 'title' ));
                ?>
        
        <p>
            <label for="<?php echo $field; ?>"><?php _e('Title:', 'themify'); ?></label><br />
            <input id="<?php echo $field; ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" value="<?php echo esc_attr( $instance['title'] ); ?>" type="text" class="widefat" />
        </p>
        <?php $field = esc_attr($this->get_field_id( 'hide_title' ));?>
        <p>
            <input class="checkbox" type="checkbox" <?php checked( $instance['hide_title'], 'on' ); ?> id="<?php echo $field; ?>" name="<?php echo esc_attr( $this->get_field_name( 'hide_title' ) ); ?>" />
            <label for="<?php echo $field; ?>"><?php _e('Hide post title', 'themify'); ?></label>
        </p>
        <?php $field = esc_attr($this->get_field_id( 'show_comment_count' ));?>
        <p>
            <input class="checkbox" type="checkbox" <?php checked( $instance['show_comment_count'], 'on' ); ?> id="<?php echo $field; ?>" name="<?php echo esc_attr( $this->get_field_name( 'show_comment_count' ) ); ?>" />
            <label for="<?php echo $field; ?>"><?php _e('Display comment count', 'themify'); ?></label>
        </p>
                <?php $field = esc_attr($this->get_field_id( 'show_count' ));?>
        <p>
            <label for="<?php echo $field; ?>"><?php _e('Number of posts:', 'themify'); ?></label>
            <input id="<?php echo $field; ?>" name="<?php echo esc_attr( $this->get_field_name( 'show_count' ) ); ?>" value="<?php echo esc_attr( $instance['show_count'] ); ?>" size="2" type="text" />
        </p>
        <?php $field = esc_attr($this->get_field_id( 'show_thumb' ));?>
        <p>
            <input class="checkbox" type="checkbox" <?php checked( $instance['show_thumb'], 'on' ); ?> id="<?php echo $field; ?>" name="<?php echo esc_attr( $this->get_field_name( 'show_thumb' ) ); ?>" />
            <label for="<?php echo $field; ?>"><?php _e('Display post thumbnail', 'themify'); ?></label>
        </p>
        
        <?php
        // only allow thumbnail dimensions if GD library supported
        if ( function_exists('imagecreatetruecolor') ) {
                    $field = esc_attr($this->get_field_id( 'thumb_width' ));
        ?>
        <p>
           <label for="<?php echo $field; ?>"><?php _e('Thumbnail size', 'themify'); ?></label> <input type="text" id="<?php echo $field; ?>" name="<?php echo esc_attr( $this->get_field_name( 'thumb_width' ) ); ?>" value="<?php echo esc_attr( $instance['thumb_width'] ); ?>" size="3" /> x <input type="text" id="<?php echo esc_attr( $this->get_field_id( 'thumb_height' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'thumb_height' ) ); ?>" value="<?php echo esc_attr( $instance['thumb_height'] ); ?>" size="3" />
        </p>
        <?php
        }
                $field = esc_attr($this->get_field_id( 'show_excerpt' ));
        ?>
        
        <p>
            <input class="checkbox" type="checkbox" <?php checked( $instance['show_excerpt'], 'on' ); ?> id="<?php echo $field; ?>" name="<?php echo esc_attr( $this->get_field_name( 'show_excerpt' ) ); ?>" />
            <label for="<?php echo $field; ?>"><?php _e('Display post excerpt', 'themify'); ?></label>
        </p>
        <?php $field = esc_attr($this->get_field_id( 'excerpt_length' ));?>
        <p>
            <label for="<?php echo $field; ?>"><?php _e('Excerpt character limit:', 'themify'); ?></label>
            <input id="<?php echo $field; ?>" name="<?php echo esc_attr( $this->get_field_name( 'excerpt_length' ) ); ?>" value="<?php echo esc_attr( $instance['excerpt_length'] ); ?>" size="1" type="text" /><br/><small><?php _e('(leave empty = full excerpt)', 'themify'); ?></small>
        </p>

        <?php
    }
}

///////////////////////////////////////////
// Google Maps Class
///////////////////////////////////////////
class Themify_Google_Maps extends WP_Widget {
    
    ///////////////////////////////////////////
    // Google Maps
    ///////////////////////////////////////////
    function __construct() {
        /* Widget settings. */
        $widget_ops = array( 'classname' => 'google-maps', 'description' => __('A map to place your location', 'themify') );

        /* Widget control settings. */
        $control_ops = array( 'id_base' => 'themify-google-maps' );

        /* Create the widget. */
        parent::__construct( 'themify-google-maps', __('Themify - Google Maps', 'themify'), $widget_ops, $control_ops );
    }
    
    ///////////////////////////////////////////
    // Widget
    ///////////////////////////////////////////
    function widget( $args, $instance ) {
        extract( $args );
            $defaults = array(
                'map_display_type'=>'dynamic',
                'address_map' =>'',
                'latlong_map'=>'',
                'zoom_map'  => 8,
                'type_map' => 'ROADMAP',
                'scrollwheel_map'=>'disable',
                'width' => '',
                'height' => '300',
                'draggable_map'=>'enable',
                'info_window_map'=>''
            );
            $instance = wp_parse_args($instance, $defaults);
        /* User-selected settings. */
        $title = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );

        /* Before widget (defined by themes). */
        echo $before_widget;

        /* Title of widget (before and after defined by themes). */
        if ( $title ) {
            echo $args['before_title'] , $title , $args['after_title'];
        }   
        
        echo '<div class="themify_google_map_wrapper" class="tf_clearfix">';

            if ($instance['map_display_type'] === 'static'){
                $args = '';
                if ($instance['address_map']!=='') {
                    $args = 'center=' . $instance['address_map'];
                } elseif($instance['latlong_map']!==''){
                    $args= 'center=' . $instance['latlong_map'];
                }
                $args .= '&zoom=' . $instance['zoom_map'];
                $args .= '&maptype=' . strtolower($instance['type_map']);
                $args .= '&size=' . (( $instance['width']!=='') ? filter_var( $instance['width'], FILTER_SANITIZE_NUMBER_INT ) : '500' ) . 'x' .  $instance['height'];
                $style = isset($instance['style']) ? esc_attr($instance['style']) : '';
            ?>
            <img style="<?php echo $style; ?>" src="https://maps.googleapis.com/maps/api/staticmap?<?php echo $args; ?>" />
        <?php }
            elseif ($instance['address_map']!=='' || $instance['latlong_map']!==''){
                $data = array();
                $data['scroll'] = $instance['scrollwheel_map'] === 'enable';
                $data['drag'] = 'enable' === $instance['draggable_map'];
                if( $instance['width']!=='' &&  ! preg_match( '/%$/', $instance['width'] ) ) {
                    $instance['width'] .= 'px';
                }
                else {
                    $instance['width'] = '100%';
                }
                $style = 'width:' . $instance['width'] . ';';
                $style .= 'height:' .$instance['height'] . 'px;';
            ?>
                <div
                    class="themify_map"
                    data-lazy="1"
                    style="<?php echo esc_attr($style); ?>"
                    data-address="<?php echo esc_attr( $instance['address_map'] !== '' ? $instance['address_map'] : $instance['latlong_map'] ) ?>"
                    data-type="<?php echo esc_attr($instance['type_map']); ?>"
                    data-zoom="<?php echo esc_attr($instance['zoom_map']); ?>"
                    data-scroll="<?php echo $data['scroll']; ?>"
                    data-drag="<?php echo $data['drag']; ?>"
                    data-info-window="<?php echo esc_attr($instance['info_window_map']); ?>"
                    data-reverse-geocoding="<?php echo $instance['address_map']==='' && $instance['latlong_map']!==''; ?>">
                </div>
            <?php
            }
            echo '</div>',$after_widget;
    }
    
    ///////////////////////////////////////////
    // Update
    ///////////////////////////////////////////
    function update( $new_instance, $old_instance ) {
        
        $instance = array();

        // Cleans the lat/lon string
        if(isset($new_instance)){
            preg_match_all("/(?<lat>[-+]?([0-9]+\.[0-9]+)).*(?<long>[-+]?([0-9]+\.[0-9]+))/", $new_instance['latlong_map'], $matches);
            $instance['latlong_map'] = !empty($matches[0]) ? str_replace(' ', '', $matches[0][0]): '';
        }
        /* Strip tags (if needed) and update the widget settings. */
        foreach(array('map_display_type','address_map','width','height','zoom_map','type_map','scrollwheel_map','draggable_map','draggable_disable_mobile_map','info_window_map') as $v){
            if(isset($new_instance[$v])){
                $instance[$v] = strip_tags($new_instance[$v]);
            }
        }
        /* Strip tags (if needed) and update the widget settings. */
        if(isset($new_instance['title'])){
            $instance['title'] = strip_tags( $new_instance['title'] );
        }
        return $instance;
    }
    
    ///////////////////////////////////////////
    // Form
    ///////////////////////////////////////////
    function form( $instance ) {

        /* Set up some default widget settings. */
        $defaults = array(
            'title' => 'Themify Google Map',
            'map_display_type' => 'dynamic',
            'address_map' => '',
            'latlong_map' => '43.6453137,-79.1831939',
            'width' => '100%',
            'height' => '300',
            'zoom_map' => 8,
            'type_map' => 'ROADMAP',
            'scrollwheel_map' => 'disable',
            'draggable_map' => 'enable',
            'draggable_disable_mobile_map' => 'yes',
            'info_window_map' => ''
        );  
        $instance = wp_parse_args( (array) $instance, $defaults ); 
                $field = esc_attr($this->get_field_id( 'title' ));
              
                ?>
        
        <p>
            <label for="<?php echo $field; ?>"><?php _e('Title', 'themify'); ?></label><br>
            <input id="<?php echo $field; ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" value="<?php echo esc_attr( $instance['title'] ); ?>" class="widefat" />
        </p>
                <?php $field = esc_attr($this->get_field_name( 'map_display_type' ));?>
        <p>
            <label><?php _e('Type:', 'themify'); ?></label><br>
            <input type="radio" name="<?php echo $field; ?>" value="dynamic" <?php checked( $instance['map_display_type'], 'dynamic' ); ?>> <?php _e('Dynamic', 'themify'); ?><br>
            <input type="radio" name="<?php echo $field; ?>" value="static" <?php checked( $instance['map_display_type'], 'static' ); ?>> <?php _e('Static', 'themify'); ?>
        </p>
        <?php $field = esc_attr($this->get_field_id( 'address_map' ));?>
        <p>
            <label for="<?php echo $field; ?>"><?php _e('Address:', 'themify'); ?></label><br>
            <textarea id="<?php echo $field; ?>" name="<?php echo esc_attr( $this->get_field_name( 'address_map' ) ); ?>" class="widefat"><?php echo esc_attr( $instance['address_map'] ); ?></textarea>
        </p>
        <?php $field = esc_attr($this->get_field_id( 'latlong_map' ));?>
        <p>
            <label for="<?php echo $field; ?>"><?php _e('Lat/Lon', 'themify'); ?></label><br>
            <input id="<?php echo $field; ?>" name="<?php echo esc_attr( $this->get_field_name( 'latlong_map' ) ); ?>" value="<?php echo esc_attr( $instance['latlong_map'] ); ?>" class="widefat" /><br/><small><?php _e('Use lat/lon instead of address (Leave address field empty to use this). Example: 43.6453137,-79.1831939', 'themify'); ?></small>
        </p>
                <?php $field = esc_attr($this->get_field_id( 'width' ));?>
        <p>
            <label for="<?php echo $field; ?>"><?php _e('Width', 'themify'); ?></label>
            <input type="text" id="<?php echo $field; ?>" name="<?php echo esc_attr( $this->get_field_name( 'width' ) ); ?>" value="<?php echo esc_attr( $instance['width'] ); ?>"/>
                <?php $field = esc_attr($this->get_field_id( 'height' ));?>
                        <label for="<?php echo $field; ?>"><?php _e('Height', 'themify'); ?></label>
            <input type="text" id="<?php echo $field; ?>" name="<?php echo esc_attr( $this->get_field_name( 'height' ) ); ?>" value="<?php echo esc_attr( $instance['height'] ); ?>"/>
        </p>
                <?php $field = esc_attr($this->get_field_id( 'zoom_map' ));?>
        <p>
            <label for="<?php echo $field; ?>"><?php _e('Zoom:', 'themify'); ?></label>
            <input type="number" min="1" max="16" id="<?php echo $field; ?>" name="<?php echo esc_attr( $this->get_field_name( 'zoom_map' ) ); ?>" value="<?php echo esc_attr( $instance['zoom_map'] ); ?>"/>
        </p>
                <?php $field = esc_attr($this->get_field_id( 'type_map' ));?>
        <p>
            <label for="<?php echo $field ?>"><?php _e('Type:', 'themify'); ?></label>
            <select id="<?php echo $field; ?>" name="<?php echo esc_attr( $this->get_field_name( 'type_map' ) ); ?>">
                <option value="ROADMAP" <?php selected( $instance['type_map'], 'ROADMAP' );?>><?php _e('Road Map', 'themify'); ?></option>
                <option value="SATELLITE" <?php selected( $instance['type_map'], 'SATELLITE' );?>><?php _e('Satellite', 'themify'); ?></option>
                <option value="HYBRID" <?php selected( $instance['type_map'], 'HYBRID' );?>><?php _e('Hybrid', 'themify'); ?></option>
                <option value="TERRAIN" <?php selected( $instance['type_map'], 'TERRAIN' );?>><?php _e('Terrain', 'themify'); ?></option>
            </select>
        </p>
                <?php $field = esc_attr($this->get_field_id( 'scrollwheel_map' ));?>
        <p>
            <label for="<?php echo $field?>"><?php _e('Scrollwheel:', 'themify'); ?></label>
            <select id="<?php echo $field; ?>" name="<?php echo esc_attr( $this->get_field_name( 'scrollwheel_map' ) ); ?>">
                <option value="disable" <?php selected( $instance['scrollwheel_map'], 'disable' );?>><?php _e('Disable', 'themify'); ?></option>
                <option value="enable" <?php selected( $instance['scrollwheel_map'], 'enable' );?>><?php _e('Enable', 'themify'); ?></option>
            </select>
        </p>
                <?php $field = esc_attr($this->get_field_id( 'draggable_map' ));?>
        <p>
            <label for="<?php echo $field?>"><?php _e('Draggable:', 'themify'); ?></label>
            <select id="<?php echo $field; ?>" name="<?php echo esc_attr( $this->get_field_name( 'draggable_map' ) ); ?>">
                <option value="disable" <?php selected( $instance['draggable_map'], 'disable' );?>><?php _e('Disable', 'themify'); ?></option>
                <option value="enable" <?php selected( $instance['draggable_map'], 'enable' );?>><?php _e('Enable', 'themify'); ?></option>
            </select>
        </p>
                <?php $field = esc_attr($this->get_field_id( 'draggable_disable_mobile_map' ));?>
        <p>
            <label for="<?php echo $field?>"><?php _e('Disable draggable on mobile:', 'themify'); ?></label>
            <select id="<?php echo $field; ?>" name="<?php echo esc_attr( $this->get_field_name( 'draggable_disable_mobile_map' ) ); ?>">
                <option value="yes" <?php selected( $instance['draggable_disable_mobile_map'], 'disable' );?>><?php _e('Yes', 'themify'); ?></option>
                <option value="no" <?php selected( $instance['draggable_disable_mobile_map'], 'enable' );?>><?php _e('No', 'themify'); ?></option>
            </select>
        </p>
                <?php $field = esc_attr($this->get_field_id( 'info_window_map' ));?>
        <p>
            <label for="<?php echo $field; ?>"><?php _e('Infowindow:', 'themify'); ?></label><br>
            <textarea id="<?php echo $field; ?>" name="<?php echo esc_attr( $this->get_field_name( 'info_window_map' ) ); ?>" class="widefat"><?php echo esc_attr( $instance['info_window_map'] ); ?></textarea>
        </p>

        <?php
    }
}

///////////////////////////////////////////
// Register Widgets
///////////////////////////////////////////
function themify_register_widgets() {
    register_widget('Themify_Feature_Posts');
    register_widget('Themify_List_Pages');
    register_widget('Themify_List_Categories');
    register_widget('Themify_Recent_Comments');
    if ( get_option( 'link_manager_enabled' ) ) {
        register_widget('Themify_Links');
    }
    register_widget('Themify_Social_Links');
    register_widget('Themify_Most_Commented');
    register_widget('Themify_Google_Maps');
    themify_register_grouped_widgets();
    $sidebars=apply_filters('themify_register_sidebars',array(
        array(
            'name' => __( 'Sidebar', 'themify' ),
            'id' => 'sidebar-main',
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget' => '</div>',
            'before_title' => '<h4 class="widgettitle">',
            'after_title' => '</h4>'
        ),
        array(
            'name' => __( 'Social Widget', 'themify' ),
            'id' => 'social-widget',
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget' => '</div>',
            'before_title' => '<strong class="widgettitle">',
            'after_title' => '</strong>'
        )
    ));
    foreach ( $sidebars as $sidebar ) {
        register_sidebar( $sidebar );
    }
}
add_action('widgets_init', 'themify_register_widgets', 1);
