<?php
/**
 * Custom functions specific to the Coffee skin
 *
 * @package Themify Shoppe
 */

/**
 * Load Google web fonts required for the skin
 *
 * @since 1.4.9
 * @return array
 */
function themify_theme_coffee_google_fonts( $fonts ) {
	if ( 'off' !== _x( 'on', 'Poppins font: on or off', 'themify' ) ) {
		$fonts['poppins'] = 'Poppins:400,300,600,700,900';
	}
	if ( 'off' !== _x( 'on', 'Playfair Display font: on or off', 'themify' ) ) {
		$fonts['playfair-display'] = 'Playfair+Display:400,700,900';
	}
	return $fonts;
}
add_filter( 'themify_google_fonts', 'themify_theme_coffee_google_fonts' );
